/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.DefaultsDescriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.OverrideDescriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.StandardDescriptorProcessor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebDescriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebInfConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlConfiguration.class);

    public WebXmlConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebInfConfiguration.class));
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = context.getResourceFactory().newClassLoaderResource(defaultsDescriptor);
            if (Resources.missing(dftResource)) {
                URL url;
                String pkg = WebXmlConfiguration.class.getPackageName().replace(".", "/") + "/";
                if (defaultsDescriptor.startsWith(pkg) && (url = WebXmlConfiguration.class.getResource(defaultsDescriptor.substring(pkg.length()))) != null) {
                    URI uri = url.toURI();
                    dftResource = context.getResourceFactory().newResource(uri);
                }
                if (Resources.missing(dftResource)) {
                    dftResource = context.newResource(defaultsDescriptor);
                }
            }
            if (Resources.isReadableFile(dftResource)) {
                context.getMetaData().setDefaultsDescriptor(new DefaultsDescriptor(dftResource));
            }
        }
        if ((webxml = this.findWebXml(context)) != null) {
            context.getMetaData().setWebDescriptor(new WebDescriptor(webxml));
            context.getContext().getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebDescriptor().getMajorVersion());
            context.getContext().getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebDescriptor().getMinorVersion());
        }
        for (String overrideDescriptor : context.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = context.getResourceFactory().newClassLoaderResource(overrideDescriptor);
            if (Resources.missing(orideResource)) {
                orideResource = context.newResource(overrideDescriptor);
            }
            if (!Resources.isReadableFile(orideResource)) continue;
            context.getMetaData().addOverrideDescriptor(new OverrideDescriptor(orideResource));
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        context.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context.getDescriptor();
        if (descriptor != null && (web = context.newResource(descriptor)) != null && !web.isDirectory()) {
            return web;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web2 = webInf.resolve("web.xml");
            if (Resources.isReadableFile(web2)) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in {}. Serving files and default/dynamic servlets only", (Object)context.getWar());
            }
        }
        return null;
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        context.setWelcomeFiles(null);
        Request.Handler handler = context.getErrorHandler();
        if (handler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)handler;
            errorPageErrorHandler.setErrorPages(null);
        }
    }
}

