/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.security;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpURI;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.IdentityService;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.UserIdentity;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.internal.DeferredAuthenticationState;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import java.security.Principal;

public interface AuthenticationState
extends Request.AuthenticationState {
    public static final AuthenticationState CHALLENGE = new ResponseSent(){

        public String toString() {
            return "CHALLENGE";
        }
    };
    public static final AuthenticationState SEND_FAILURE = new ResponseSent(){

        public String toString() {
            return "FAILURE";
        }
    };
    public static final AuthenticationState SEND_SUCCESS = new ResponseSent(){

        public String toString() {
            return "SEND_SUCCESS";
        }
    };

    public static AuthenticationState getAuthenticationState(Request request) {
        AuthenticationState authenticationState;
        Request.AuthenticationState state = Request.getAuthenticationState(request);
        return state instanceof AuthenticationState ? (authenticationState = (AuthenticationState)state) : null;
    }

    public static void setAuthenticationState(Request request, AuthenticationState authenticationState) {
        Request.setAuthenticationState(request, authenticationState);
    }

    public static Principal getUserPrincipal(Request request) {
        Succeeded succeeded = AuthenticationState.authenticate(request);
        if (succeeded == null) {
            return null;
        }
        return succeeded.getUserIdentity().getUserPrincipal();
    }

    public static Succeeded authenticate(Request request) {
        AuthenticationState authenticationState = AuthenticationState.getAuthenticationState(request);
        if (authenticationState instanceof Deferred) {
            Deferred deferred = (Deferred)authenticationState;
            authenticationState = deferred.authenticate(request);
        }
        if (authenticationState instanceof Succeeded) {
            Succeeded succeeded = (Succeeded)authenticationState;
            return succeeded;
        }
        return null;
    }

    public static Succeeded authenticate(Request request, Response response, Callback callback) {
        Deferred deferred;
        AuthenticationState authenticationState = AuthenticationState.getAuthenticationState(request);
        if (authenticationState instanceof Deferred && (authenticationState = (deferred = (Deferred)authenticationState).authenticate(request, response, callback)) instanceof ResponseSent) {
            return null;
        }
        if (authenticationState instanceof Succeeded) {
            Succeeded succeeded = (Succeeded)authenticationState;
            return succeeded;
        }
        Response.writeError(request, response, callback, 403);
        return null;
    }

    public static Succeeded login(String username, String password, Request request, Response response) {
        Deferred deferred;
        Succeeded undeferred;
        AuthenticationState authenticationState = AuthenticationState.getAuthenticationState(request);
        if (authenticationState instanceof Succeeded) {
            throw new HttpException.RuntimeException(500, "Already authenticated");
        }
        if (authenticationState instanceof Deferred && (undeferred = (deferred = (Deferred)authenticationState).login(username, password, request, response)) != null) {
            AuthenticationState.setAuthenticationState(request, undeferred);
            return undeferred;
        }
        return null;
    }

    public static boolean logout(Request request, Response response) {
        AuthenticationState authenticationState = AuthenticationState.getAuthenticationState(request);
        if (authenticationState instanceof Succeeded) {
            Succeeded succeededAuthentication = (Succeeded)authenticationState;
            succeededAuthentication.logout(request, response);
            return true;
        }
        if (authenticationState instanceof Deferred) {
            Deferred deferred = (Deferred)authenticationState;
            deferred.logout(request, response);
            return true;
        }
        return false;
    }

    public static Deferred defer(LoginAuthenticator loginAuthenticator) {
        return new DeferredAuthenticationState(loginAuthenticator);
    }

    public static interface Succeeded
    extends AuthenticationState {
        public String getAuthenticationType();

        public UserIdentity getUserIdentity();

        @Override
        default public Principal getUserPrincipal() {
            UserIdentity user = this.getUserIdentity();
            if (user != null) {
                return user.getUserPrincipal();
            }
            return null;
        }

        public boolean isUserInRole(String var1);

        public void logout(Request var1, Response var2);
    }

    public static interface Deferred
    extends AuthenticationState {
        public static boolean isDeferred(Response response) {
            return response instanceof DeferredResponse;
        }

        @Override
        public Succeeded authenticate(Request var1);

        public AuthenticationState authenticate(Request var1, Response var2, Callback var3);

        public Succeeded login(String var1, Object var2, Request var3, Response var4);

        public void logout(Request var1, Response var2);

        public IdentityService.Association getAssociation();

        public static interface DeferredResponse
        extends Response {
        }
    }

    public static interface ResponseSent
    extends AuthenticationState {
    }

    public static class ServeAs
    implements AuthenticationState {
        private final HttpURI _uri;

        public ServeAs(HttpURI uri) {
            this._uri = uri;
        }

        public Request wrap(Request request) {
            return Request.serveAs(request, this._uri);
        }
    }
}

