/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow.tracking;

import com.dataiku.dss.shadelib.org.mlflow.api.proto.Service;
import com.dataiku.dss.shadelib.org.mlflow.tracking.MlflowClient;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActiveRun {
    private MlflowClient client;
    private Service.RunInfo runInfo;

    ActiveRun(Service.RunInfo runInfo, MlflowClient client) {
        this.runInfo = runInfo;
        this.client = client;
    }

    public String getId() {
        return this.runInfo.getRunId();
    }

    public void logParam(String key, String value) {
        this.client.logParam(this.getId(), key, value);
    }

    public void setTag(String key, String value) {
        this.client.setTag(this.getId(), key, value);
    }

    public void logMetric(String key, double value) {
        this.logMetric(key, value, 0);
    }

    public void logMetric(String key, double value, int step) {
        this.client.logMetric(this.getId(), key, value, System.currentTimeMillis(), step);
    }

    public void logMetrics(Map<String, Double> metrics) {
        this.logMetrics(metrics, 0);
    }

    public void logMetrics(Map<String, Double> metrics, int step) {
        List<Service.Metric> protoMetrics = metrics.entrySet().stream().map(metric -> Service.Metric.newBuilder().setKey((String)metric.getKey()).setValue((Double)metric.getValue()).setTimestamp(System.currentTimeMillis()).setStep(step).build()).collect(Collectors.toList());
        this.client.logBatch(this.getId(), protoMetrics, Collections.emptyList(), Collections.emptyList());
    }

    public void logParams(Map<String, String> params) {
        List<Service.Param> protoParams = params.entrySet().stream().map(param -> Service.Param.newBuilder().setKey((String)param.getKey()).setValue((String)param.getValue()).build()).collect(Collectors.toList());
        this.client.logBatch(this.getId(), Collections.emptyList(), protoParams, Collections.emptyList());
    }

    public void setTags(Map<String, String> tags) {
        List<Service.RunTag> protoTags = tags.entrySet().stream().map(tag -> Service.RunTag.newBuilder().setKey((String)tag.getKey()).setValue((String)tag.getValue()).build()).collect(Collectors.toList());
        this.client.logBatch(this.getId(), Collections.emptyList(), Collections.emptyList(), protoTags);
    }

    public void logArtifact(Path localPath) {
        this.client.logArtifact(this.getId(), localPath.toFile());
    }

    public void logArtifact(Path localPath, String artifactPath) {
        this.client.logArtifact(this.getId(), localPath.toFile(), artifactPath);
    }

    public void logArtifacts(Path localPath) {
        this.client.logArtifacts(this.getId(), localPath.toFile());
    }

    public void logArtifacts(Path localPath, String artifactPath) {
        this.client.logArtifacts(this.getId(), localPath.toFile(), artifactPath);
    }

    public String getArtifactUri() {
        return this.runInfo.getArtifactUri();
    }

    public void endRun() {
        this.endRun(Service.RunStatus.FINISHED);
    }

    public void endRun(Service.RunStatus status) {
        this.client.setTerminated(this.getId(), status);
    }
}

