/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.databricks.client.support.exceptions.ErrorException;

public class ETSubQuery
extends ETUnaryRelationalExpr {
    private final boolean m_isCorrelated;
    private final boolean m_isInFromClause;
    private boolean m_isOpen;

    public ETSubQuery(ETRelationalExpr eTRelationalExpr, boolean bl, boolean bl2, boolean[] blArray) {
        super(eTRelationalExpr, blArray);
        this.m_isCorrelated = bl;
        this.m_isInFromClause = bl2;
        this.m_isOpen = false;
        if (this.m_isCorrelated) {
            eTRelationalExpr.setCanReopenAfterClosed();
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.getOperand().getRowCount();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.getOperand().retrieveData(n, eTDataRequest);
    }

    @Override
    public boolean isOpen() {
        if (this.m_isCorrelated) {
            return this.m_isOpen;
        }
        return this.getOperand().isOpen();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        if (!this.m_isCorrelated || this.m_isInFromClause) {
            this.getOperand().open(cursorType);
        }
        if (this.m_isCorrelated) {
            this.m_isOpen = true;
        }
    }

    @Override
    public void reset() throws ErrorException {
        if (this.m_isCorrelated) {
            this.getOperand().close(true);
            this.getOperand().open(CursorType.FORWARD_ONLY);
        } else {
            this.getOperand().reset();
        }
    }

    @Override
    public void close(boolean bl) {
        this.getOperand().close(bl);
        this.m_isOpen = false;
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.getOperand().move();
    }
}

