/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.http.HttpStatus;

@UIModel
public class InfoMessage {
    public final Severity severity;
    public final boolean isFatal;
    public final String code;
    public final String title;
    public final String details;
    @Nullable
    public transient String adminDetails;
    public final String message;
    public Integer line;
    public Integer column;
    public Integer lineTo;
    public String context;
    public String governLink;
    private final transient MessageCode codeAsObject;

    public static InfoMessage warning(MessageCode codeObj, String details) {
        return new InfoMessage(Severity.WARNING, codeObj, details);
    }

    public static InfoMessage info(MessageCode codeObj, String details) {
        return new InfoMessage(Severity.INFO, codeObj, details);
    }

    public static InfoMessage success(MessageCode codeObj, String details) {
        return new InfoMessage(Severity.SUCCESS, codeObj, details);
    }

    public static InfoMessage error(MessageCode codeObj, String details) {
        return new InfoMessage(Severity.ERROR, false, codeObj, details);
    }

    public static InfoMessage errorV(MessageCode codeObj, @PrintFormat String format, Object ... args) {
        return new InfoMessage(Severity.ERROR, false, codeObj, String.format(format, args));
    }

    public static InfoMessage fatal(MessageCode codeObj, String details) {
        return new InfoMessage(Severity.ERROR, true, codeObj, details);
    }

    public static InfoMessage fatalV(MessageCode codeObj, @PrintFormat String format, Object ... args) {
        return new InfoMessage(Severity.ERROR, true, codeObj, String.format(format, args));
    }

    public static InfoMessage info(String title, String details) {
        return new InfoMessage(Severity.INFO, title, details);
    }

    public static InfoMessage warning(String title, String details) {
        return new InfoMessage(Severity.WARNING, title, details);
    }

    public static InfoMessage warning(String title) {
        return new InfoMessage(Severity.WARNING, title, null);
    }

    public static InfoMessage warningV(MessageCode codeObj, @PrintFormat String format, Object ... args) {
        return new InfoMessage(Severity.WARNING, false, codeObj, String.format(format, args));
    }

    public static InfoMessage error(String title, String details) {
        return new InfoMessage(Severity.ERROR, false, title, details);
    }

    public static InfoMessage error(String title) {
        return new InfoMessage(Severity.ERROR, false, title, null);
    }

    public static InfoMessage fatal(String title, String details) {
        return new InfoMessage(Severity.ERROR, true, title, details);
    }

    public static InfoMessage fatal(String title) {
        return new InfoMessage(Severity.ERROR, true, title, null);
    }

    public static boolean anyFatal(Collection<InfoMessage> messages) {
        return InfoMessage.firstFatal(messages) != null;
    }

    public static boolean hasAnyOfSeverity(Collection<? extends InfoMessage> messages, Severity severity) {
        for (InfoMessage infoMessage : messages) {
            if (infoMessage.severity != severity) continue;
            return true;
        }
        return false;
    }

    public static InfoMessage firstFatal(Collection<InfoMessage> messages) {
        for (InfoMessage message : messages) {
            if (message.severity != Severity.ERROR || !message.isFatal) continue;
            return message;
        }
        return null;
    }

    public InfoMessage(Severity severity, MessageCode codeObj, String details) {
        this(severity, severity == Severity.ERROR, codeObj, details);
    }

    public InfoMessage(Severity severity, boolean isFatal, MessageCode codeObj, String details) {
        this.severity = severity;
        this.isFatal = isFatal;
        this.title = codeObj.getCodeTitle();
        this.code = codeObj.getCode();
        this.codeAsObject = codeObj;
        this.details = details;
        this.message = this.getMessage(this.title, this.details);
    }

    public InfoMessage(Severity severity, boolean isFatal, MessageCode codeObj, String details, @Nullable String adminDetails) {
        this(severity, isFatal, codeObj, details);
        this.adminDetails = adminDetails;
    }

    public InfoMessage(Severity severity, String title, String details) {
        this(severity, severity == Severity.ERROR, title, details);
    }

    public InfoMessage(Severity severity, boolean isFatal, String title, String details) {
        this(severity, isFatal, title, null, details);
    }

    public InfoMessage(Severity severity, boolean isFatal, String title, String code, String details) {
        this.severity = severity;
        this.isFatal = isFatal;
        this.title = title;
        this.details = details;
        this.code = code;
        this.codeAsObject = null;
        this.message = this.getMessage(this.title, this.details);
    }

    private String getMessage(String title, String details) {
        if (title != null && StringUtils.isBlank((CharSequence)details)) {
            return title;
        }
        if (title == null && details != null) {
            return details;
        }
        return title + ": " + details;
    }

    public InfoMessage withPos(int line, int column) {
        this.line = line;
        this.column = column;
        return this;
    }

    public InfoMessage withLineRange(int lineFrom, int lineTo) {
        this.line = lineFrom;
        this.lineTo = lineTo;
        return this;
    }

    public InfoMessage withCodeContext(String context) {
        this.context = context;
        return this;
    }

    public InfoMessage withGovernLink(String governLink) {
        this.governLink = governLink;
        return this;
    }

    public CodedException asCodedException() {
        if (this.codeAsObject == null) {
            return new CodedException((MessageCode)GenericCodes.ERR_UNKNOWN, this.message);
        }
        return new CodedException(this.codeAsObject, this.message);
    }

    @VisibleForTesting
    public Severity getSeverity() {
        return this.severity;
    }

    @VisibleForTesting
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }

    public int hashCode() {
        int h = 17;
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.severity});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.code});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.title});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.details});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.adminDetails});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.message});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.line});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.column});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.lineTo});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.context});
        h = 31 * h + Objects.hashCode((Object[])new Object[]{this.governLink});
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InfoMessage)) {
            return false;
        }
        InfoMessage other = (InfoMessage)o;
        return Objects.equal((Object)((Object)this.severity), (Object)((Object)other.severity)) && Objects.equal((Object)this.code, (Object)other.code) && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.details, (Object)other.details) && Objects.equal((Object)this.adminDetails, (Object)other.adminDetails) && Objects.equal((Object)this.message, (Object)other.message) && Objects.equal((Object)this.line, (Object)other.line) && Objects.equal((Object)this.column, (Object)other.column) && Objects.equal((Object)this.lineTo, (Object)other.lineTo) && Objects.equal((Object)this.context, (Object)other.context) && Objects.equal((Object)this.governLink, (Object)other.governLink);
    }

    public static enum Severity {
        SUCCESS(Level.INFO),
        INFO(Level.INFO),
        WARNING(Level.WARN),
        ERROR(Level.ERROR);

        public final Level logLevel;

        private Severity(Level logLevel) {
            this.logLevel = logLevel;
        }
    }

    public static interface MessageCode {
        public String getCode();

        public String getCodeTitle();

        public FixabilityCategory getFixability();

        default public HttpStatus getHttpStatus() {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    public static enum GenericCodes implements MessageCode
    {
        ERR_UNKNOWN("An error happened", FixabilityCategory.IRRELEVANT);

        private final String title;
        private final FixabilityCategory fixability;

        private GenericCodes(String title, FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        @Override
        public String getCode() {
            return this.name();
        }

        @Override
        public String getCodeTitle() {
            return this.title;
        }

        @Override
        public FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    @UIModel
    public static enum FixabilityCategory {
        USER_CONFIG,
        USER_CONFIG_DATASET,
        USER_CONFIG_FOLDER,
        USER_CONFIG_OR_BUILD,
        USER_CONFIG_OR_ADMIN,
        USER_FILL_CREDENTIALS,
        ADMIN_INSTALLATION,
        ADMIN_SETTINGS_SECURITY,
        ADMIN_SETTINGS_CONNECTIONS,
        ADMIN_SETTINGS_CONTAINERS,
        ADMIN_SETTINGS_CODEENVS,
        ADMIN_SETTINGS_INTERNAL_CODEENVS,
        ADMIN_SETTINGS_PLUGINS,
        ADMIN_SETTINGS_MISSING_PLUGIN,
        ADMIN_SETTINGS_USER_PROFILE,
        ADMIN_SETTINGS_MISC,
        ADMIN_TROUBLESHOOTING,
        PROJECT_SECURITY,
        API_CALL,
        READ_FUTURE_LOG,
        DATA,
        MISSING_APP,
        GOVERNANCE_STATUS,
        THIRD_PARTY_SYSTEM_CONNECTION,
        HADOOP_INTEGRATION,
        THIRD_PARTY_SYSTEM,
        IRRELEVANT,
        UNKNOWN;

    }

    @UIModel
    public static class InfoMessages {
        public Set<InfoMessage> messages = new HashSet<InfoMessage>();
        @Nullable
        public Severity maxSeverity;
        public boolean anyMessage;
        public boolean success;
        public boolean warning;
        public boolean error;
        public boolean fatal;

        public boolean isEmpty() {
            return this.messages.isEmpty();
        }

        public void removeCode(MessageCode code) {
            Iterator<InfoMessage> it = this.messages.iterator();
            while (it.hasNext()) {
                InfoMessage im = it.next();
                if (im.code == null || !code.getCode().equals(im.code)) continue;
                it.remove();
            }
            this.summarize();
        }

        public void prefixMessageDetails(String prefix) {
            this.messages = this.messages.stream().map(infoMessage -> {
                String newDetails = prefix + infoMessage.details;
                if (infoMessage.codeAsObject == null) {
                    return new InfoMessage(infoMessage.severity, infoMessage.isFatal, infoMessage.title, infoMessage.code, newDetails);
                }
                return new InfoMessage(infoMessage.severity, infoMessage.isFatal, infoMessage.codeAsObject, newDetails);
            }).collect(Collectors.toSet());
        }

        public void prefixMessageTitles(String prefix) {
            this.messages = this.messages.stream().map(infoMessage -> {
                String newTitle = prefix + infoMessage.title;
                return new InfoMessage(infoMessage.severity, infoMessage.isFatal, newTitle, infoMessage.code, infoMessage.details);
            }).collect(Collectors.toSet());
        }

        public void addCodePositionToDetails() {
            this.messages = this.messages.stream().map(infoMessage -> {
                String newDetails = String.format("%s (line %s, column %s: \"%s\")", infoMessage.details, infoMessage.line, infoMessage.column, infoMessage.context);
                if (infoMessage.codeAsObject == null) {
                    return new InfoMessage(infoMessage.severity, infoMessage.isFatal, infoMessage.title, infoMessage.code, newDetails);
                }
                return new InfoMessage(infoMessage.severity, infoMessage.isFatal, infoMessage.codeAsObject, newDetails);
            }).collect(Collectors.toSet());
        }

        public InfoMessages withoutCode(MessageCode code) {
            InfoMessages ret = JSON.deepCopy(this);
            ret.removeCode(code);
            return ret;
        }

        public InfoMessages withSuccess(MessageCode code, String details) {
            this.messages.add(InfoMessage.success(code, details));
            this.summarize();
            return this;
        }

        public InfoMessages withInfo(MessageCode code, String details) {
            this.messages.add(InfoMessage.info(code, details));
            this.summarize();
            return this;
        }

        public InfoMessages withWarning(MessageCode code, String details) {
            this.messages.add(InfoMessage.warning(code, details));
            this.summarize();
            return this;
        }

        public void addMessage(InfoMessage message) {
            this.messages.add(message);
            this.summarize();
        }

        public InfoMessages withError(MessageCode code, String details) {
            this.messages.add(InfoMessage.error(code, details));
            this.summarize();
            return this;
        }

        public InfoMessages withError(MessageCode code, @Nonnull String details, @Nullable String adminDetails) {
            this.messages.add(new InfoMessage(Severity.ERROR, false, code, details, adminDetails));
            this.summarize();
            return this;
        }

        public InfoMessages withErrorV(MessageCode code, @PrintFormat String details, Object ... args) {
            this.messages.add(InfoMessage.error(code, String.format(details, args)));
            this.summarize();
            return this;
        }

        public InfoMessages withFatal(MessageCode code, String details) {
            this.messages.add(InfoMessage.fatal(code, details));
            this.summarize();
            return this;
        }

        public InfoMessages withFatalV(MessageCode code, @PrintFormat String details, Object ... args) {
            this.messages.add(InfoMessage.fatal(code, String.format(details, args)));
            this.summarize();
            return this;
        }

        public InfoMessages withSuccessV(MessageCode code, @PrintFormat String details, Object ... args) {
            this.messages.add(InfoMessage.success(code, String.format(details, args)));
            this.summarize();
            return this;
        }

        public InfoMessages withWarningV(MessageCode code, @PrintFormat String details, Object ... args) {
            this.messages.add(InfoMessage.warning(code, String.format(details, args)));
            this.summarize();
            return this;
        }

        public InfoMessages withInfoV(MessageCode code, @PrintFormat String details, Object ... args) {
            this.messages.add(InfoMessage.info(code, String.format(details, args)));
            this.summarize();
            return this;
        }

        public InfoMessage firstFatal() {
            return InfoMessage.firstFatal(this.messages);
        }

        public boolean anyFatal() {
            return InfoMessage.anyFatal(this.messages);
        }

        public void summarize() {
            this.anyMessage = !this.messages.isEmpty();
            this.fatal = this.anyFatal();
            this.error = InfoMessage.hasAnyOfSeverity(this.messages, Severity.ERROR);
            this.success = InfoMessage.hasAnyOfSeverity(this.messages, Severity.SUCCESS);
            this.warning = InfoMessage.hasAnyOfSeverity(this.messages, Severity.WARNING);
            this.maxSeverity = null;
            if (this.error) {
                this.maxSeverity = Severity.ERROR;
            } else if (this.warning) {
                this.maxSeverity = Severity.WARNING;
            } else if (this.success) {
                this.maxSeverity = Severity.SUCCESS;
            } else if (this.anyMessage) {
                this.maxSeverity = Severity.INFO;
            }
        }

        public void mergeFrom(@Nullable InfoMessages other) {
            if (other != null) {
                this.messages.addAll(other.messages);
            }
            this.summarize();
        }

        public InfoMessages withMessages(@Nullable InfoMessages other) {
            this.mergeFrom(other);
            return this;
        }

        public String report() {
            return this.report("; ");
        }

        public String report(String joinOn) {
            ArrayList parts = Lists.newArrayList();
            for (InfoMessage message : this.messages) {
                parts.add(String.valueOf((Object)message.severity) + " : " + message.message);
            }
            return Joiner.on((String)joinOn).join((Iterable)parts);
        }
    }
}

