/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.servlets;

import com.dataiku.hproxy.model.PingResponse;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.servlets.BaseServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PingServlet
extends BaseServlet {
    private static final long serialVersionUID = -1L;
    private static Logger logger = Logger.getLogger(PingServlet.class);

    public PingServlet(Context ctx) {
        super(ctx);
    }

    @Override
    public void serviceCall(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        logger.info((Object)("Received command : " + path));
        try {
            switch (path) {
                case "/ping": {
                    this.handlePing(resp);
                    break;
                }
                default: {
                    this.sendError(resp, new Exception("Unknown command"));
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.sendError(resp, e);
        }
    }

    private void handlePing(HttpServletResponse resp) throws IOException {
        logger.info((Object)"Received ping");
        PingResponse pr = new PingResponse();
        pr.ok = true;
        this.writeJSON(resp, pr);
    }
}

