/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactDescription;
import com.dataiku.gh.core.models.export.ExportFile;
import com.dataiku.gh.core.models.export.ExportType;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.search.ArtifactSearchQuery;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIArtifactSearchResults;
import com.dataiku.gh.core.models.ui.UIGetArtifactsResult;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.export.IExportService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArtifactsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IArtifactsService artifactsService;
    @Autowired
    private IExportService exportService;

    @AuditedCall(value={"msgType", "artifact-get", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifacts/get"}, method={RequestMethod.GET})
    @ResponseBody
    public UIArtifact get(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactsService.getArtifact(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "artifact-export", "artifactId", "${artifactId}", "exportType", "${exportType}"})
    @RequestMapping(value={"/api/artifacts/export"}, method={RequestMethod.GET})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String artifactId, @RequestParam ExportType exportType) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        ExportFile file = this.exportService.exportArtifact(authCtx, artifactId, exportType);
        this.writeStream(resp, file.data, file.mimeType.mimeType, file.fileName);
    }

    @AuditedCall(value={"msgType", "artifact-list-by-artifact-ids", "artifactIds", "${artifactIds}"})
    @RequestMapping(value={"/api/artifacts/list-by-artifact-ids"}, method={RequestMethod.POST})
    @ResponseBody
    public UIGetArtifactsResult listByArtifactIds(HttpServletRequest req, @RequestParam List<String> artifactIds) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return UIGetArtifactsResult.build(this.artifactsService.getArtifactsOrExceptions(authCtx, artifactIds, null));
    }

    @AuditInline
    @RequestMapping(value={"/api/artifacts/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ARTIFACT_SAVE)
    @ResponseBody
    public UIArtifact save(HttpServletRequest req, @RequestParam Artifact artifact) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIArtifact uiArtifact = this.artifactsService.saveArtifact(authCtx, artifact);
            this.auditTrailService.generic("artifact-save").with("artifactId", uiArtifact.artifact.id).emit();
            return uiArtifact;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifacts/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_CREATE)
    @ResponseBody
    public ArtifactDescription create(HttpServletRequest req, @RequestParam Artifact artifact) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArtifactDescription artifactDescription = this.artifactsService.createArtifact(authCtx, artifact);
            this.auditTrailService.generic("artifact-create").with("artifactId", artifactDescription.artifactId).emit();
            return artifactDescription;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "artifact-delete", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifacts/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ARTIFACT_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.artifactsService.deleteArtifact(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "artifact-search"})
    @RequestMapping(value={"/api/artifacts/search"}, method={RequestMethod.POST})
    @ResponseBody
    public UIArtifactSearchResults search(HttpServletRequest req, @RequestParam ArtifactSearchQuery artifactSearchQuery) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactsService.search(authCtx, artifactSearchQuery);
    }

    @RequestMapping(value={"/api/artifacts/save/prepare"}, method={RequestMethod.POST})
    @ResponseBody
    public UIArtifact prepareSave(HttpServletRequest req, @RequestParam Artifact artifact) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactsService.prepareSaveArtifact(authCtx, artifact);
    }
}

