/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.artifacts;

import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.visitors.IArtifactVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ArtifactWorkflow {
    public Map<String, ArtifactWorkflowStep> steps = new HashMap<String, ArtifactWorkflowStep>();

    public void accept(IArtifactVisitor artifactVisitor) {
        artifactVisitor.visit(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArtifactWorkflow that = (ArtifactWorkflow)object;
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hashCode(this.steps);
    }

    public static boolean stepStatusesAreEqual(@Nullable ArtifactWorkflow aw1, @Nullable ArtifactWorkflow aw2) {
        if (aw1 == null && aw2 == null) {
            return true;
        }
        if (aw1 == null || aw2 == null) {
            return false;
        }
        return ArtifactWorkflow.stepsStatusesAreContained(aw1, aw2) && ArtifactWorkflow.stepsStatusesAreContained(aw2, aw1);
    }

    private static boolean stepsStatusesAreContained(ArtifactWorkflow aw1, ArtifactWorkflow aw2) {
        for (Map.Entry<String, ArtifactWorkflowStep> entry : aw1.steps.entrySet()) {
            ArtifactWorkflowStep.StepStatus otherStepStatus = Optional.ofNullable(aw2.steps.get(entry.getKey())).map(s -> s.status).orElse(ArtifactWorkflowStep.StepStatus.NOT_STARTED);
            if (otherStepStatus == entry.getValue().status) continue;
            return false;
        }
        return true;
    }

    public boolean isStarted() {
        return this.steps.values().stream().anyMatch(artifactWorkflowStep -> !artifactWorkflowStep.isNotStarted());
    }

    public boolean hasOnGoingStep() {
        return this.steps.values().stream().anyMatch(ArtifactWorkflowStep::isOngoing);
    }
}

