/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.dao.UsersDAO;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class TemplateContext {
    protected static final DefaultObjectWrapperBuilder WRAPPER_BUILDER = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_30);
    protected Map<String, UsersDAO.User> users;
    protected String userLogin;
    protected Map<String, Map<String, EffectivePermissionsItem>> permissionMapping;

    public void enrichWithUsers(Map<String, UsersDAO.User> users) {
        this.users = users;
        this.getChildren().forEach(c -> c.enrichWithUsers(users));
    }

    public void enrichWithCurrentUserLogin(String userLogin) {
        this.userLogin = userLogin;
        this.getChildren().forEach(c -> c.enrichWithCurrentUserLogin(userLogin));
    }

    public void enrichWithPermissions(Map<String, Map<String, EffectivePermissionsItem>> permissionMapping) {
        this.permissionMapping = permissionMapping;
        this.getChildren().forEach(c -> c.enrichWithPermissions(permissionMapping));
    }

    public List<EnrichedArtifact> retrieveAllEnrichedArtifactChildren() {
        ArrayList<EnrichedArtifact> enrichedArtifacts = new ArrayList<EnrichedArtifact>();
        this.getChildren().forEach(c -> enrichedArtifacts.addAll(c.retrieveAllEnrichedArtifactChildren()));
        return enrichedArtifacts;
    }

    public abstract List<? extends TemplateContext> getChildren();

    public abstract TemplateModel buildTemplateModel();
}

