/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV14200
extends Migration {
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_project", "blueprint_version_default.json"}), "bp.system.dataiku_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
        String allArtifactIdsToUnHide = "WITH GOVERNED_ARTIFACT_IDS AS (\nSELECT reference_relationship_artifact_id_from AS artifact_id\nFROM reference_relationships\nWHERE reference_relationship_json #>> '{\"relationshipData\", \"fieldId\"}' = 'governed_by'\n),\n\nGOVERNED_BUT_HIDDEN AS (\nSELECT artifact_id, artifact_blueprint_id, artifact_json\nFROM artifacts\nWHERE artifact_json #>> '{\"fields\", \"hidden_in_governable_items_table\"}' = 'true'\nAND artifact_id IN (SELECT artifact_id from GOVERNED_ARTIFACT_IDS)\n),\n\nBUNDLES_TO_UN_HIDE AS (\nSELECT artifact_id\nFROM GOVERNED_BUT_HIDDEN\nWHERE artifact_blueprint_id = 'bp.system.dataiku_bundle'\n),\n\nMODEL_VERSIONS_TO_UN_HIDE AS (\nSELECT artifact_id\nFROM GOVERNED_BUT_HIDDEN\nWHERE artifact_blueprint_id = 'bp.system.dataiku_saved_model_version'\n),\n\nMODELS_TO_UN_HIDE AS (\nSELECT artifact_id\nFROM GOVERNED_BUT_HIDDEN\nWHERE artifact_blueprint_id = 'bp.system.dataiku_saved_model'\n\nUNION\n\nSELECT reference_relationship_artifact_id_to AS artifact_id\nFROM reference_relationships\nWHERE reference_relationship_artifact_id_from\nIN (\n    SELECT artifact_id\n    FROM MODEL_VERSIONS_TO_UN_HIDE\n   )\nAND reference_relationship_json #>> '{\"relationshipData\", \"fieldId\"}' = 'dataiku_saved_model'\n),\n\nPROJECTS_TO_UN_HIDE AS (\nSELECT artifact_id\nFROM GOVERNED_BUT_HIDDEN\nWHERE artifact_blueprint_id = 'bp.system.dataiku_project'\n\nUNION\n\nSELECT reference_relationship_artifact_id_to AS artifact_id\nFROM reference_relationships\nWHERE reference_relationship_artifact_id_from\nIN (\n    SELECT artifact_id\n    FROM MODELS_TO_UN_HIDE\n   )\nAND reference_relationship_json #>> '{\"relationshipData\", \"fieldId\"}' = 'dataiku_project'\n\nUNION\n\nSELECT reference_relationship_artifact_id_to AS artifact_id\nFROM reference_relationships\nWHERE reference_relationship_artifact_id_from\nIN (\n    SELECT artifact_id\n    FROM BUNDLES_TO_UN_HIDE\n   )\nAND reference_relationship_json #>> '{\"relationshipData\", \"fieldId\"}' = 'dataiku_project'\n)\n\n\nSELECT artifact_id FROM artifacts\nWHERE artifact_json #>> '{\"fields\", \"hidden_in_governable_items_table\"}' = 'true'\nAND artifact_id IN (\nSELECT artifact_id FROM PROJECTS_TO_UN_HIDE\nUNION\nSELECT artifact_id FROM MODELS_TO_UN_HIDE\nUNION\nSELECT artifact_id FROM MODEL_VERSIONS_TO_UN_HIDE\nUNION\nSELECT artifact_id FROM BUNDLES_TO_UN_HIDE\n)\n";
        MigrationEntitiesUtilsBetweenV13300AndBeyond.fixArtifacts(dbMigrationDAO, "artifact_id IN (" + allArtifactIdsToUnHide + ")", MigrationV14200::removeHidden, actionId, migrationTS);
    }

    private static JsonObject removeHidden(JsonObject input) {
        Optional<JsonObject> fields = MigrationJsonUtils.getObjectSubpath((JsonElement)input, "fields");
        fields.ifPresent(fieldsJsonObject -> fieldsJsonObject.remove("hidden_in_governable_items_table"));
        return input;
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        MigrationV14200.updateInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration");
        MigrationV14200.updateInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration_history");
        MigrationV14200.updateArtifactAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "artifact_governance_settings");
        MigrationV14200.updateArtifactAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "artifact_governance_settings_history");
        MigrationV14200.addScriptToInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration");
        MigrationV14200.addScriptToInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration_history");
    }

    private static void updateInstanceAutoGovernanceConfiguration(JdbcTemplate jdbcTemplate, String tableName) {
        jdbcTemplate.update(String.format("UPDATE %s\nSET CONFIGURATION_ITEM_JSON = JSONB_SET(\n  CONFIGURATION_ITEM_JSON,\n  '{instanceAutoGovernanceConfiguration}',\n  (%s)\n)\nWHERE CONFIGURATION_ITEM_ID = 'default-autogovern';", tableName, MigrationV14200.generateAutoGovernanceConfigurationJson("CONFIGURATION_ITEM_JSON -> 'instanceAutoGovernanceConfiguration'")));
    }

    private static void updateArtifactAutoGovernanceConfiguration(JdbcTemplate jdbcTemplate, String tableName) {
        jdbcTemplate.update(String.format("UPDATE %s\nSET ARTIFACT_GOVERNANCE_SETTINGS_JSON = (%s);", tableName, MigrationV14200.generateAutoGovernanceConfigurationJson("ARTIFACT_GOVERNANCE_SETTINGS_JSON")));
    }

    private static String generateAutoGovernanceConfigurationJson(String jsonPath) {
        return String.format("SELECT JSONB_OBJECT_AGG(\n    key,\n    CASE\n      WHEN jsonb_typeof(value) = 'object' AND value ? 'status' AND value ->> 'status' = 'DISABLED' THEN\n        (value - 'status') || '{\"action\":\"DO_NOTHING\"}'::jsonb\n      WHEN jsonb_typeof(value) = 'object' AND value ? 'status' AND value ->> 'status' = 'ENABLED' THEN\n        (value - 'status') || '{\"action\":\"GOVERN\"}'::jsonb\n      WHEN jsonb_typeof(value) = 'object' AND value ? 'status' THEN\n        (value - 'status') || jsonb_build_object('action', value -> 'status')\n      ELSE\n        value\n    END\n  ) FROM jsonb_each(%s) AS conf(key, value)", jsonPath);
    }

    private static void addScriptToInstanceAutoGovernanceConfiguration(JdbcTemplate jdbcTemplate, String tableName) {
        jdbcTemplate.update(String.format("UPDATE %s\nSET configuration_item_json = jsonb_set(\nconfiguration_item_json,\n'{script}',\nto_jsonb('" + MigrationV14200.getDefaultScript() + "'::text))\nWHERE configuration_item_id = 'default-autogovern'", tableName));
    }

    private static String getDefaultScript() {
        return "from govern.core.autogovernance_handler import get_autogovernance_handler\n\nhandler = get_autogovernance_handler()\nhandler.script_output.action= \"DO_NOTHING\"\n\n\n### -------------------------------\n### Using logging to debug this script\n### You can use the logger instance to log info that will be printed in the governserver.log files\n\n# import logging\n# logging.basicConfig(level=logging.INFO)\n# logger = logging.getLogger(__name__)\n# logger.warning(\"here is a warning\")\n# logger.info(\"here an info message\")\n\n\n### -------------------------------\n### Get the current artifact:\n\n# artifact = handler.enrichedArtifact.artifact\n\n### Get the artifact id:\n\n# artifact.id\n\n### To get a field given its ID:\n\n# artifact.fields.get(\"fieldId\")\n\n\n### -------------------------------\n### To mark the execution of the hook as failed and prevent the action:\n\n# handler.status = \"ERROR\"\n# handler.message = \"The reason why the script failed\"\n\n\n### -------------------------------\n### To specify the script configuration you want to apply to the current artifact.\n\n### in the case of automatically hiding an artifact\n# handler.script_output.action= \"HIDE\"\n# handler.script_output.status= \"AUTO\"\n\n### in the case of suggesting hiding an artifact\n# handler.script_output.action= \"HIDE\"\n# handler.script_output.status= \"SUGGESTED\"\n\n### in the case of automatically governing an artifact\n# handler.script_output.action= \"GOVERN\"\n# handler.script_output.blueprintVersionId= {\"blueprintId\": \"bp.system.govern_bundle\", \"versionId\": \"bv.system.default\"}\n# handler.script_output.status= \"AUTO\"\n\n### in the case of suggesting governing an artifact\n# handler.script_output.action= \"GOVERN\"\n# handler.script_output.blueprintVersionId= {\"blueprintId\": \"bp.system.govern_bundle\", \"versionId\": \"bv.system.default\"}\n# handler.script_output.status= \"SUGGESTED\"\n\n### in the case of a project with custom children configuration\n# handler.script_output.childrenConfiguration = {\n#     \"bundlesConfig\": {\n#         \"action\": \"DO_NOTHING\",\n#     },\n#     \"modelsConfig\":  {\n#         \"action\": \"GOVERN\",\n#         \"status\": \"SUGGESTED\",\n#         \"blueprintVersionId\": {\"blueprintId\": \"bp.system.govern_model\", \"versionId\": \"bv.system.default\"\n#     },\n#     \"modelVersionsConfig\": {\n#         \"action\": \"HIDE\",\n#         \"status\": \"SUGGESTED\"\n#     },\n# }\n\n### in the case of governing a project with existing project\n# handler.script_output.projectExistingArtifactId= \"ar.922\"\n\n### in the case of governing a project with business initiative\n# handler.script_output.projectBusinessInitiativeArtifactId= \"ar.692\"\n\n### in the case of a model with custom children configuration\n# handler.script_output.childrenConfiguration = {\n#     \"modelVersionsConfig\": {\n#         \"action\": \"HIDE\",\n#         \"status\": \"SUGGESTED\"\n#     },\n# }\n\n### in the case of prefilling a govern artifact\n# handler.script_output.artifactPrefill.fields[\"fieldId\"] = \"myNewValue\"\n\n\n### -------------------------------\n### To use the public api:\n### Warning: do not use any side-effect api calls (artifact create, save, delete) since this script might be run automatically multiple times\n\n# another_artifact = handler.client.get_artifact(\"ar.1773\")\n# another_artifact_definition = another_artifact.get_definition().get_raw()\n# another_artifact_current_step = another_artifact_definition.get(\"status\", {}).get(\"stepId\")\n# another_artifact_signoff = another_artifact.get_signoff(another_artifact_current_step)\n# another_artifact_signoff_status = another_artifact_signoff.get_definition().get_raw().get(\"status\")";
    }
}

