/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.blueprints.HookPhase;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.google.gson.JsonObject;

@PolyJSON(value={@Mapping(value=LogicalHookRequest.class, type="logical-hook-request"), @Mapping(value=MigrationPathRequest.class, type="migration-path-request"), @Mapping(value=ArtifactActionScriptRequest.class, type="artifact-action-script-request"), @Mapping(value=ActionScriptRequest.class, type="action-script-request"), @Mapping(value=AutoGovernanceScriptRequest.class, type="autogovernance-script-request")})
public abstract class PythonExecutionRequest {
    public String ticketSecret;
    public long timeout;

    public static class AutoGovernanceScriptRequest
    extends PythonExecutionRequest {
        public static final String TYPE = "autogovernance-script-request";
        public String script;
        public EnrichedArtifact dkuEnrichedArtifact;
    }

    public static class ActionScriptRequest
    extends PythonExecutionRequest {
        public static final String TYPE = "action-script-request";
        public String script;
        public String authCtxIdentifier;
        public JsonObject params;
    }

    public static class ArtifactActionScriptRequest
    extends PythonExecutionRequest {
        public static final String TYPE = "artifact-action-script-request";
        public String script;
        public EnrichedArtifact dkuEnrichedArtifact;
        public String authCtxIdentifier;
        public JsonObject params;
    }

    public static class MigrationPathRequest
    extends PythonExecutionRequest {
        public static final String TYPE = "migration-path-request";
        public BlueprintVersionMigrationPath migrationPath;
        public EnrichedArtifact sourceEnrichedArtifact;
        public EnrichedBlueprintVersion targetEnrichedBlueprintVersion;
    }

    public static class LogicalHookRequest
    extends PythonExecutionRequest {
        public static final String TYPE = "logical-hook-request";
        public LogicalHook hook;
        public HookPhase hookPhase;
        public EnrichedArtifact existingEnrichedArtifact;
        public EnrichedArtifact newEnrichedArtifact;
    }
}

