/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.assignments;

import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.storage.roles.assignments.IArtifactRoleAssignmentsDAO;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactRoleAssignmentsDataService
implements IArtifactRoleAssignmentsDataService {
    @Autowired
    private IArtifactRoleAssignmentsDAO artifactRoleAssignmentsDAO;
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IArtifactDAO artifactDAO;

    @Override
    @GHMandatoryTransaction
    public ArtifactRoleAssignments getArtifactRoleAssignments(String artifactId) throws IOException {
        return (ArtifactRoleAssignments)this.artifactRoleAssignmentsDAO.getMandatory(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    @Nullable
    public ArtifactRoleAssignments getArtifactRoleAssignmentsOrNull(String artifactId) throws IOException {
        return (ArtifactRoleAssignments)this.artifactRoleAssignmentsDAO.getOrNull(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactRoleAssignments createArtifactRoleAssignments(ArtifactRoleAssignments artifactRoleAssignments) throws IOException {
        return this.validateAndSave(artifactRoleAssignments, true);
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactRoleAssignments saveArtifactRoleAssignments(ArtifactRoleAssignments artifactRoleAssignments) throws IOException {
        return this.validateAndSave(artifactRoleAssignments, false);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteArtifactRoleAssignments(String artifactId) throws IOException {
        if (!this.artifactRoleAssignmentsDAO.exists(artifactId)) {
            throw new ValidationException("Artifact role assignments for artifact ID: " + artifactId + " doesn't exist");
        }
        ArtifactRoleAssignments artifactRoleAssignments = (ArtifactRoleAssignments)this.artifactRoleAssignmentsDAO.getMandatory(artifactId);
        this.lockArtifactRoleAssignmentsAndRelated(artifactRoleAssignments);
        this.artifactRoleAssignmentsDAO.delete(artifactId);
    }

    private ArtifactRoleAssignments validateAndSave(ArtifactRoleAssignments artifactRoleAssignments, boolean creation) throws IOException {
        if (creation == this.artifactRoleAssignmentsDAO.exists(artifactRoleAssignments.artifactId)) {
            throw new ValidationException("Artifact role assignments for artifact ID: " + artifactRoleAssignments.artifactId + (creation ? " already exists" : " doesn't exist"));
        }
        this.lockArtifactRoleAssignmentsAndRelated(artifactRoleAssignments);
        if (creation) {
            this.artifactRoleAssignmentsDAO.create(artifactRoleAssignments);
        } else {
            this.artifactRoleAssignmentsDAO.save(artifactRoleAssignments);
        }
        return (ArtifactRoleAssignments)this.artifactRoleAssignmentsDAO.getMandatory(artifactRoleAssignments.artifactId);
    }

    private void lockArtifactRoleAssignmentsAndRelated(ArtifactRoleAssignments artifactRoleAssignments) throws IOException {
        this.artifactRoleAssignmentsDAO.lock(artifactRoleAssignments.artifactId);
        this.artifactDAO.lock(artifactRoleAssignments.artifactId);
        for (String roleId : artifactRoleAssignments.roleAssignmentsRules.keySet()) {
            this.roleDAO.lock(roleId);
        }
    }
}

