/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.user_config.SavedArtifactFilterConfiguration;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.visitors.ISavedArtifactFilterConfigurationVisitor;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SavedArtifactFilterConfigurationValidator
implements ISavedArtifactFilterConfigurationVisitor {
    @Override
    public void visit(SavedArtifactFilterConfiguration filterConfig) {
        if (StringUtils.isBlank((CharSequence)filterConfig.id)) {
            throw new ValidationException("Artifact filter configuration has missing id");
        }
        if (StringUtils.isBlank((CharSequence)filterConfig.label)) {
            throw new ValidationException("Artifact filter configuration with id `" + filterConfig.id + "` has missing label");
        }
        if (Objects.isNull(filterConfig.artifactFilter) || !filterConfig.artifactFilter.getType().equals("and") && !filterConfig.artifactFilter.getType().equals("or")) {
            throw new ValidationException("Artifact filter configuration with id `" + filterConfig.id + "` can only be of type and/or.");
        }
    }
}

