/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.services.LogsService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LogsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LogsService logsService;

    @AuditedCall(value={"msgType", "admin-logs-list"})
    @RequestMapping(value={"/api/admin/logs/list"})
    public void listNames(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        LogsController.writeJSON((HttpServletResponse)resp, this.logsService.listLogs());
    }

    @AuditedCall(value={"msgType", "admin-log-get", "name", "${name}"})
    @RequestMapping(value={"/api/admin/logs/get-content"})
    public void getContent(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        LogsService.LogDesc log = this.logsService.getLogContent(name);
        LogsController.writeJSON((HttpServletResponse)resp, (Object)log);
    }

    @AuditedCall(value={"msgType", "admin-logs-download", "name", "${name}"})
    @RequestMapping(value={"/api/admin/logs/get-files"})
    public void getLogFiles(HttpServletRequest req, HttpServletResponse resp, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdminNoXSRF(req);
        }
        String dlName = DKUtils.getCompressedLogFileName((String)name);
        resp.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", dlName));
        this.logsService.streamLogs(name, true, (OutputStream)resp.getOutputStream());
    }
}

