/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers.admin;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.activity.GlobalUsageSummaryBuilder;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdminMonitoringController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.monitoringpapi.js");

    @AuditedCall(value={"msgType", "admin-get-usage-summary"})
    @RequestMapping(value={"/api/admin/monitoring/get-global-usage-summary"})
    public void getGlobalUsageSummary(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)new GlobalUsageSummaryBuilder().buildGlobalMonitoringReport());
    }
}

