/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services.licensing;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistrationService {
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static Logger logger = Logger.getLogger((String)"dss.saas");

    public static String parseLicense(String license) {
        if ((license = license.trim()).contains("{")) {
            return license;
        }
        try {
            String l2 = new String(Base64.decodeBase64((String)license), "utf8");
            if (l2.contains("{")) {
                return l2;
            }
            throw new IOException("");
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid license", "This does not look like a valid Dataiku Govern license");
        }
    }

    private void fillLoginDetails(RegistrationStatus status) {
        status.initialLogin = "admin";
        status.initialPassword = ApplicationConfigurator.getParams().getParam("dku.registration.initialPassword", "admin");
        status.displayPassword = ApplicationConfigurator.getParams().getBoolParam("dku.registration.displayPassword", status.initialPassword.equals("admin"));
        status.initialPasswordHint = ApplicationConfigurator.getParams().getParam("dku.registration.initialPasswordHint", null);
    }

    public RegistrationStatus initialRegisterCommunity(String userFirstname, String userLastname, String userEmail, String instanceId, License license) throws Exception {
        throw new IllegalArgumentException("The community license is not allowed on this node");
    }

    public RegistrationStatus postInitialRegisterLicensed(License license) throws Exception {
        if (ApplicationConfigurator.getLicensingMode() != DKUApp.LicensingMode.ON_PREMISE_DISCONNECTED) {
            throw new IllegalArgumentException("DSS cannot be registered");
        }
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        if (ls.hasLicense && !ls.community) {
            throw new IllegalArgumentException("Dataiku Govern is already registered");
        }
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("The community license is not allowed on your host");
        }
        JSON.prettyToFile((Object)license, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
        ApplicationConfigurator.invalidateCachedLicenseInstanceId();
        if (license.content.instanceId != null) {
            DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"instance-id.txt"), (String)license.content.instanceId);
        }
        RegistrationStatus rs = new RegistrationStatus();
        this.fillLoginDetails(rs);
        if (license.content.licensee != null && license.content.licensee.firstName != null) {
            this.usersDAO.deleteUser(rs.initialLogin);
            UsersDAO.User u = this.usersDAO.addUser(rs.initialLogin, rs.initialPassword);
            u.groups.add(this.usersDAO.getDefaultAdminGroup((boolean)true).name);
            u.displayName = license.content.licensee.firstName + " " + license.content.licensee.lastName;
            u.email = license.content.licensee.email;
            UsersService.UserSaveContext usc = UsersService.UserSaveContext.buildInstanceInit();
            this.usersService.saveUser(u, true, usc, null);
        }
        GeneralSettingsService.setJustAfterRegister(true);
        if (!rs.displayPassword) {
            rs.initialPassword = null;
        }
        return rs;
    }

    public void setOfflineLicense(License license) throws Exception {
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("This license is not allowed on your host");
        }
        if (license.content.instanceId != null) {
            DKUFileUtils.writeFileUTF8((File)ApplicationConfigurator.getFile((String)"instance-id.txt"), (String)license.content.instanceId);
        }
        JSON.prettyToFile((Object)license, (File)ApplicationConfigurator.getFile((String)"config/license.json"));
        ApplicationConfigurator.invalidateCachedLicenseInstanceId();
    }

    @UIModel
    static class RegistrationStatus {
        boolean community;
        boolean displayPassword;
        String initialLogin;
        String initialPassword;
        String initialPasswordHint;

        RegistrationStatus() {
        }
    }
}

