/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.distributed.metrics;

public class ContainerUsageMetrics {
    private int nbDead;
    private int nbPending;
    private int nbReady;
    private final boolean isKubernetesEnabled;

    public ContainerUsageMetrics(int nbDead, int nbPending, int nbReady, boolean isKubernetesEnabled) {
        this.nbDead = nbDead;
        this.nbPending = nbPending;
        this.nbReady = nbReady;
        this.isKubernetesEnabled = isKubernetesEnabled;
    }

    public synchronized void incrementDead() {
        ++this.nbDead;
    }

    public synchronized void incrementPending() {
        ++this.nbPending;
    }

    public synchronized void incrementReady() {
        ++this.nbReady;
    }

    public boolean isKubernetesEnabled() {
        return this.isKubernetesEnabled;
    }

    public ContainerUsageMetrics add(ContainerUsageMetrics other) {
        return new ContainerUsageMetrics(this.nbDead + other.nbDead, this.nbPending + other.nbPending, this.nbReady + other.nbReady, this.isKubernetesEnabled || other.isKubernetesEnabled);
    }
}

