/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public class UserQueryFilter {
    private final UsedValue<String> groupName;
    private final UsedValue<String> login;
    private final UsedValue<String> email;
    private final Map<String, UsedValue<?>> values = new HashMap();

    private static String getStringValueOrNull(JsonElement jsonElement) {
        return jsonElement == null || jsonElement.isJsonNull() ? null : jsonElement.getAsString();
    }

    public UserQueryFilter(String groupName, String login, String email) {
        this.groupName = new UsedValue<String>(StringUtils.isEmpty((CharSequence)groupName) ? null : groupName);
        this.login = new UsedValue<String>(StringUtils.isEmpty((CharSequence)login) ? null : login);
        this.email = new UsedValue<String>(StringUtils.isEmpty((CharSequence)email) ? null : email);
        this.values.put("login", this.login);
        this.values.put("groupName", this.groupName);
        this.values.put("email", this.email);
    }

    public String getLogin() {
        return this.login.get();
    }

    public String getGroupName() {
        return this.groupName.get();
    }

    @CheckForNull
    public String getEmail() {
        return this.email.get();
    }

    public Set<String> getUnusedFilters() {
        return this.values.keySet().stream().filter(name -> !this.values.get(name).wasUsedBySupplier()).collect(Collectors.toSet());
    }

    static {
        JSON.registerAdapter(UserQueryFilter.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            return new UserQueryFilter(UserQueryFilter.getStringValueOrNull(jsonObject.get("groupName")), UserQueryFilter.getStringValueOrNull(jsonObject.get("login")), UserQueryFilter.getStringValueOrNull(jsonObject.get("email")));
        });
    }

    static class UsedValue<T> {
        private boolean used = false;
        private final T value;

        public UsedValue(T value) {
            this.value = value;
        }

        public T get() {
            this.used = true;
            return this.value;
        }

        public boolean wasUsedBySupplier() {
            return this.value == null || this.used;
        }
    }
}

