/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.ldap;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.GroupProfile;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserRemappingRule;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.security.ldap.LdapGroupMembershipUserAttribute;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@UIModel
public class LdapSettings
implements UserSupplierSettings,
UserCredentialsAuthenticatorSettings {
    public String url;
    public boolean useTls;
    public boolean trustAllCertificates = true;
    public String bindDN;
    public String bindPassword;
    public String userFilter = "(&(objectClass=posixAccount)(uid={USERNAME}))";
    public String displayNameAttribute = "cn";
    public String emailAttribute = "mail";
    public boolean enableGroups = true;
    public String groupFilter = "(&(objectClass=posixGroup)(memberUid={USERNAME}))";
    public String groupNameAttribute = "cn";
    public List<String> authorizedGroups = new ArrayList<String>();
    public boolean enabled;
    @UINullable
    public Integer order;
    public boolean autoImportUsers = true;
    public boolean autoSyncUsersAtLoginTime = false;
    public boolean allowOnDemandUsersSync = true;
    public String defaultUserProfile;
    public List<GroupProfile> groupProfiles = new ArrayList<GroupProfile>();
    public boolean authenticationEnabled = true;
    public boolean allowOnDemandUsersProvisioning = false;
    public String allGroupsFilter = "(objectClass=posixGroup)";
    public String allUsersFilter = "(objectClass=posixAccount)";
    public String usernameAttribute = "uid";
    public String groupMembershipAttribute = "memberUid";
    public LdapGroupMembershipUserAttribute groupMembershipUserAttribute = LdapGroupMembershipUserAttribute.UID;
    public List<UserRemappingRule> remappingRules = new ArrayList<UserRemappingRule>();

    public void encryptFields(PasswordEncryptionService cryptoService) {
        this.bindPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.bindPassword);
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.bindPassword = cryptoService.decryptIfEncrypted(this.bindPassword);
    }

    @Override
    public UserSourceType getUserSourceType() {
        return UserSourceType.LDAP;
    }

    @Override
    public Set<String> getAuthorizedGroups() {
        return this.enableGroups ? this.authorizedGroups.stream().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public List<UserRemappingRule> getUserRemappingRules() {
        return this.remappingRules;
    }

    @Override
    public boolean isOnDemandUsersProvisioningEnabled() {
        return this.allowOnDemandUsersProvisioning;
    }

    @Override
    public List<GroupProfile> getProfileMappings() {
        return this.groupProfiles;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUsersAutoProvisioningAtLoginTimeEnabled() {
        return this.autoImportUsers;
    }

    @Override
    public boolean isUsersAutoSyncAtLoginTimeEnabled() {
        return this.autoSyncUsersAtLoginTime;
    }

    @Override
    public boolean isOnDemandUsersSyncEnabled() {
        return this.allowOnDemandUsersSync;
    }

    @Override
    public String getDefaultUserProfile() {
        return this.defaultUserProfile;
    }

    @Override
    public Integer getOrder() {
        return this.order != null ? this.order.intValue() : this.getUserSourceType().getDefaultOrder();
    }

    @Override
    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }
}

