/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.ConcreteRelFileAttribute;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.ReadWriteFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

public class SubReadWriteFS
extends ReadWriteFSBase {
    private final ReadOnlyFS base;
    private final RelFile pathInBase;

    public SubReadWriteFS(ReadOnlyFS base, RelFile pathInBase) throws IOException {
        super(FileContentFactory.DEFAULT);
        if (!base.isDirectory(pathInBase)) {
            throw new IOException("Not a directory: " + String.valueOf(pathInBase));
        }
        this.base = base;
        this.pathInBase = pathInBase;
    }

    private RelFile toBase(RelFile file) {
        return this.pathInBase.append(file.getElements());
    }

    private RelFile fromBase(RelFile file) {
        if (file.isChildOf(this.pathInBase)) {
            return file.skipHead(this.pathInBase.length());
        }
        throw new RuntimeException("Invalid path " + String.valueOf(file));
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        return this.base.listFilesUnordered(this.toBase(directory)).stream().map(this::fromBase).collect(Collectors.toList());
    }

    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        return this.base.readContentUnsafe(this.toBase(file));
    }

    @Override
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        if (file.isRoot()) {
            return new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.DIRECTORY, -1L, -1L);
        }
        final RelFileAttribute attrs = this.base.getAttributes(this.toBase(file));
        if (attrs == null) {
            return null;
        }
        final RelFile fileFromAttrs = this.fromBase(attrs.getFile());
        return new RelFileAttribute(){

            @Override
            public RelFile getFile() {
                return fileFromAttrs;
            }

            @Override
            public RelFileAttribute.FileType getFileType() {
                return attrs.getFileType();
            }

            @Override
            public long getLastModified() {
                return attrs.getLastModified();
            }

            @Override
            public long getLength() {
                return attrs.getLength();
            }
        };
    }

    @Override
    public boolean deleteFile(RelFile file) throws IOException {
        if (file.isRoot()) {
            return false;
        }
        return ((ReadWriteFS)this.base).deleteFile(this.toBase(file));
    }

    @Override
    public boolean deleteDirectory(RelFile directory) throws IOException {
        if (directory.isRoot()) {
            return false;
        }
        return ((ReadWriteFS)this.base).deleteDirectory(this.toBase(directory));
    }

    @Override
    public boolean makeDirectory(RelFile directory) throws IOException {
        if (directory.isRoot()) {
            return true;
        }
        return ((ReadWriteFS)this.base).makeDirectory(this.toBase(directory));
    }

    @Override
    public void writeContentUnsafeNoMkdir(RelFile file, FileContent content) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        ((ReadWriteFS)this.base).writeContentUnsafeNoMkdir(this.toBase(file), content);
    }

    @Override
    public RelFileOutputStream writeStreamNoMkdir(RelFile file) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        RelFileOutputStream os = ((ReadWriteFS)this.base).writeStreamNoMkdir(this.toBase(file));
        RelFile fileFromOs = this.fromBase(os.file);
        return new RelFileOutputStream(fileFromOs, (OutputStream)((Object)os));
    }

    @Override
    public void writeBytes(RelFile file, byte[] bytes) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        ((ReadWriteFS)this.base).writeBytes(this.toBase(file), bytes);
    }

    @Override
    public void writeStringUTF8NoMkdir(RelFile file, String content) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        ((ReadWriteFS)this.base).writeStringUTF8NoMkdir(this.toBase(file), content);
    }

    @Override
    public <T> void writeObjectUnsafeNoMkdir(RelFile file, T obj) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        ((ReadWriteFS)this.base).writeObjectUnsafeNoMkdir(this.toBase(file), obj);
    }

    @Override
    public void writeCompressedBytesUnsafeNoMkdir(RelFile file, ReadOnlyFS.CompressedFileData compressedFileData) throws IOException {
        if (file.isRoot()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        ((ReadWriteFS)this.base).writeCompressedBytesUnsafeNoMkdir(this.toBase(file), compressedFileData);
    }
}

