/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.impl;

import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.impl.StreamTracker;
import com.dataiku.dip.transactions.utils.ReadWriteUpgradableLock;
import java.io.File;
import java.io.IOException;

public class YOLOTransactionImpl
extends ProxiedReadOnlyFS
implements Transaction {
    private final CachedReadFS cachedReadFS;
    private final File root;
    private final ReadWriteUpgradableLock lock;
    private final StreamTracker streamTracker = new StreamTracker(this);
    private boolean alive = true;
    public final TransactionDebugInfo debugInfo;
    private final DebugTransactionRegistry registry;

    public YOLOTransactionImpl(File root, DebugTransactionRegistry registry, CachedReadFS cachedReadFS, ReadWriteUpgradableLock lock, TransactionDebugInfo debugInfo) {
        this.cachedReadFS = cachedReadFS;
        this.root = root;
        this.lock = lock;
        this.registry = registry;
        this.debugInfo = debugInfo;
        this.debugInfo.state = TransactionProvider.TransactionState.RUNNING;
        this.debugInfo.startedTime = System.currentTimeMillis();
        this.registry.registerRead(this);
    }

    @Override
    protected synchronized ReadOnlyFS getDelegateFS() {
        return this.cachedReadFS;
    }

    @Override
    public synchronized boolean isAlive() {
        return this.alive;
    }

    @Override
    protected synchronized RelFileInputStream wrapFSInputStream(RelFileInputStream stream) {
        final ReadWriteUpgradableLock.ReadLock lockHandle = this.lock.acquireUnfairReadLock();
        RelFileInputStream lockedStream = new RelFileInputStream(stream){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    lockHandle.close();
                }
            }
        };
        return this.streamTracker.track(lockedStream);
    }

    @Override
    protected synchronized <T> T wrapFSAccess(ProxiedReadOnlyFS.WrappedMethodCall<T> r) throws IOException {
        if (!this.isAlive()) {
            throw new RuntimeException("The transaction has been closed");
        }
        try (ReadWriteUpgradableLock.ReadLock lockHandle = this.lock.acquireUnfairReadLock();){
            T t = super.wrapFSAccess(r);
            return t;
        }
    }

    @Override
    public File resolve(RelFile file) {
        return file.resolve(this.root);
    }

    @Override
    public synchronized void close() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        this.streamTracker.close();
        this.debugInfo.endTime = System.currentTimeMillis();
        this.registry.unregister(this);
    }

    @Override
    public TransactionDebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

