/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.springframework.stereotype.Component;

@Component
public class OperatingSystemInformation {
    private final OperatingSystemMXBean operatingSystemMXBean;
    private boolean glibcVersionChecked = false;
    private String cachedGlibcVersion = null;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.operatingSystemInformation");

    OperatingSystemInformation() {
        try {
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get OperatingSystemMXBean, you might be running an unsupported JVM");
        }
    }

    public boolean isLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public double getSystemCpuLoad() {
        return this.operatingSystemMXBean.getSystemCpuLoad();
    }

    public int getAvailableProcessors() {
        return this.operatingSystemMXBean.getAvailableProcessors();
    }

    public long getTotalMemoryInBytes() {
        return this.operatingSystemMXBean.getTotalPhysicalMemorySize();
    }

    @Nullable
    public Long getAvailableMemoryInKilobytes() {
        List<String> memInfoLines;
        if (!this.isLinux()) {
            logger.trace((Object)"Can only compute available memory on Linux");
            return null;
        }
        try {
            memInfoLines = Files.readAllLines(Path.of("/proc/meminfo", new String[0]));
        }
        catch (IOException e) {
            return null;
        }
        return OperatingSystemInformation.parseMemAvailable(memInfoLines);
    }

    @VisibleForTesting
    static Long parseMemAvailable(List<String> meminfoLines) {
        Pattern pattern = Pattern.compile("^MemAvailable:\\s+(\\d+)\\s+kB$");
        for (String line : meminfoLines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            try {
                return Long.valueOf(matcher.group(1));
            }
            catch (Exception e) {
                logger.traceV((Throwable)e, "Failed to parse MemAvailable from /proc/meminfo: %s", new Object[]{line});
                return null;
            }
        }
        logger.trace((Object)"Didn't find MemAvailable in /proc/meminfo");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getGlibcVersion() {
        if (this.glibcVersionChecked) {
            return this.cachedGlibcVersion;
        }
        this.glibcVersionChecked = true;
        if (!this.isLinux()) {
            logger.trace((Object)"Not on Linux, skipping glibc version check");
            return null;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("ldd", "--version");
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String firstLine = reader.readLine();
                boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    logger.trace((Object)"ldd --version timed out");
                    String string = null;
                    return string;
                }
                if (process.exitValue() != 0) {
                    logger.trace((Object)"ldd --version exited with non-zero status");
                    String string = null;
                    return string;
                }
                String string = this.cachedGlibcVersion = OperatingSystemInformation.parseGlibcVersion(firstLine);
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    static String parseGlibcVersion(String lddOutput) {
        if (lddOutput == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(".*\\s+(\\d+\\.\\d+)(?:\\.\\d+)?");
        Matcher matcher = pattern.matcher(lddOutput);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public boolean isGlibcVersionAtLeast(String requiredVersion) {
        String actualVersion = this.getGlibcVersion();
        if (actualVersion == null) {
            return false;
        }
        try {
            return OperatingSystemInformation.compareGlibcVersions(actualVersion, requiredVersion) >= 0;
        }
        catch (Exception e) {
            logger.traceV((Throwable)e, "Failed to compare glibc versions", new Object[0]);
            return false;
        }
    }

    @VisibleForTesting
    static int compareGlibcVersions(String version1, String version2) {
        int minor2;
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int major1 = Integer.parseInt(parts1[0]);
        int minor1 = parts1.length > 1 ? Integer.parseInt(parts1[1]) : 0;
        int major2 = Integer.parseInt(parts2[0]);
        int n = minor2 = parts2.length > 1 ? Integer.parseInt(parts2[1]) : 0;
        if (major1 != major2) {
            return Integer.compare(major1, major2);
        }
        return Integer.compare(minor1, minor2);
    }
}

