/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.QueryParam;
import com.dataiku.dss.shadelibdatabricks.com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GrpcTranscodingQueryParamsSerializer {
    private static final List<Class<?>> primitiveTypes = Arrays.asList(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, String.class);

    public static List<QueryParamPair> serialize(Object o) {
        Map<String, Object> flattened = GrpcTranscodingQueryParamsSerializer.flattenObject(o, true);
        ArrayList<QueryParamPair> result = new ArrayList<QueryParamPair>();
        for (Map.Entry<String, Object> entry : flattened.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                for (Object v : (Collection)value) {
                    result.add(new QueryParamPair(key, v.toString()));
                }
                continue;
            }
            result.add(new QueryParamPair(key, value.toString()));
        }
        return result;
    }

    private static String getFieldName(Field f) {
        QueryParam queryParam = f.getAnnotation(QueryParam.class);
        JsonProperty jsonProperty = f.getAnnotation(JsonProperty.class);
        if (queryParam != null) {
            return queryParam.value();
        }
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        return f.getName();
    }

    private static Map<String, Object> flattenObject(Object o, Boolean onlyAnnotatedFields) {
        Field[] fields;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Field f : fields = o.getClass().getDeclaredFields()) {
            if (onlyAnnotatedFields.booleanValue() && f.getAnnotation(QueryParam.class) == null) continue;
            f.setAccessible(true);
            try {
                String name = GrpcTranscodingQueryParamsSerializer.getFieldName(f);
                Object value = f.get(o);
                if (value == null) continue;
                Class<?> type = f.getType();
                if (primitiveTypes.contains(type) || Iterable.class.isAssignableFrom(type) || type.isEnum()) {
                    result.put(name, value);
                    continue;
                }
                Map<String, Object> flattened = GrpcTranscodingQueryParamsSerializer.flattenObject(value, false);
                for (Map.Entry<String, Object> entry : flattened.entrySet()) {
                    result.put(name + "." + entry.getKey(), entry.getValue());
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            finally {
                f.setAccessible(false);
            }
        }
        return result;
    }

    public static class QueryParamPair {
        private final String key;
        private final String value;

        public QueryParamPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

