/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.google.common.collect;

import com.dataiku.dss.shadelibdatabricks.com.google.common.annotations.GwtCompatible;
import com.dataiku.dss.shadelibdatabricks.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelibdatabricks.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelibdatabricks.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.dataiku.dss.shadelibdatabricks.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelibdatabricks.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    static final ImmutableList<Object> EMPTY = new RegularImmutableList<Object>(new Object[0], 0);
    @VisibleForTesting
    final transient @Nullable Object[] array;
    private final transient int size;

    RegularImmutableList(@Nullable Object[] array, int size) {
        this.array = array;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @Nullable Object[] internalArray() {
        return this.array;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.size;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int dstOff) {
        System.arraycopy(this.array, 0, dst, dstOff, this.size);
        return dstOff + this.size;
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return (E)Objects.requireNonNull(this.array[index]);
    }
}

