/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.spark.WriteMode$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DeltaWriter$
extends NativeFormatWriter {
    public static DeltaWriter$ MODULE$;
    private final Logger logger;

    static {
        new DeltaWriter$();
    }

    public void saveDeltaDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df2, String partition, Enumeration.Value writeMode) {
        org.apache.spark.sql.Dataset dataset;
        Dataset dataset2 = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset2.getPartitioningSchema(), (String)partition) : Partition.newNP();
        String path = handler.getFullyQualifiedRootPath();
        handler.addExtraConf(df2.sqlContext().sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        if (dssPartition.isNP() || dssPartition.isAll()) {
            dataset = this.adaptDataFrame(df2, dataset2.getSchema());
        } else {
            this.logger().info((Object)new StringBuilder(32).append("Write to partition ").append(partition).append(" with scheme ").append(JSON.json((Object)dataset2.getPartitioningSchema())).toString());
            dataset = (org.apache.spark.sql.Dataset)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(dssPartition.getDimensionValues().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
                String pattern;
                SchemaColumn sc;
                Object object = df2.schema().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaWriter$.$anonfun$saveDeltaDataset$2(e, x$1))).isDefined() ? df2.schema().apply((String)e.getKey()).dataType() : ((sc = dataset2.getSchema().getColumn((String)e.getKey())) != null ? package$.MODULE$.dkuToSpark(sc).dataType() : (e.getValue() instanceof TimeDimensionValue ? ((pattern = dataset2.getPartitioningSchema().getFilePathPattern()).contains("=%Y-%M-%D/") || pattern.contains("=%Y-%0M-%0D/") ? DateType$.MODULE$ : TimestampType$.MODULE$) : StringType$.MODULE$));
                DataType sparkType = object;
                DimensionValue dimensionValue = (DimensionValue)e.getValue();
                if (dimensionValue instanceof TimeDimensionValue) {
                    TimeDimensionValue timeDimensionValue = (TimeDimensionValue)dimensionValue;
                    Timestamp timestamp = new Timestamp(timeDimensionValue.getUTCCalendar().getTimeInMillis());
                    return new Tuple2(e.getKey(), (Object)functions$.MODULE$.lit((Object)timestamp).cast(sparkType));
                }
                return new Tuple2(e.getKey(), (Object)functions$.MODULE$.lit((Object)((DimensionValue)e.getValue()).id()).cast(sparkType));
            }, Set$.MODULE$.canBuildFrom())).foldLeft(this.adaptDataFrame(df2, dataset2.getSchema()), (Function2 & Serializable & scala.Serializable)(df, t) -> df.withColumn((String)t._1(), (Column)t._2()));
        }
        org.apache.spark.sql.Dataset dssDataframe = dataset;
        this.logger().info((Object)new StringBuilder(32).append("Saving dataframe as Delta (").append(writeMode).append(") to ").append(path).toString());
        Enumeration.Value value = writeMode;
        Enumeration.Value value2 = WriteMode$.MODULE$.Append();
        DataFrameWriter dfw = dssDataframe.write().mode(!(value != null ? !value.equals(value2) : value2 != null) ? "append" : "overwrite");
        DataFrameWriter dfwp = dssPartition.isNP() || dssPartition.isAll() ? dfw : dfw.partitionBy((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(dssPartition.getScheme().getDimensionNames()).asScala());
        dfwp.format("delta").save(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            DeltaWriter$.$anonfun$adaptDataFrame$1(dssSchema, dssDataframe, df, field);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$saveDeltaDataset$2(Map.Entry e$1, StructField x$1) {
        return x$1.name().equals(e$1.getKey());
    }

    public static final /* synthetic */ void $anonfun$adaptDataFrame$1(Schema dssSchema$1, ObjectRef dssDataframe$1, org.apache.spark.sql.Dataset df$2, StructField field) {
        DataType dataType;
        SchemaColumn sc = dssSchema$1.getColumn(field.name());
        DataType dataType2 = field.dataType();
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = field.dataType();
            DataType dataType4 = package$.MODULE$.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                if (sc != null) {
                    Type type = sc.getType();
                    Type type2 = Type.DATE;
                    if (!(type != null ? !type.equals(type2) : type2 != null)) {
                        String tzId = TimeZone.getDefault().getID();
                        MODULE$.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                        dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df$2.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
                        return;
                    }
                }
                return;
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = field.dataType()) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType))))))))))) {
            return;
        }
        if (dataType instanceof DecimalType) {
            MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as double").toString());
            dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$2.col(field.name()).cast((DataType)DoubleType$.MODULE$));
            return;
        }
        if (dataType instanceof DateType) {
            if (sc != null) {
                Type type = sc.getType();
                Type type3 = Type.DATE;
                if (!(type != null ? !type.equals(type3) : type3 != null)) {
                    String tzId = TimeZone.getDefault().getID();
                    MODULE$.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                    dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df$2.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
                    return;
                }
            }
            return;
        }
        MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as string").toString());
        dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$2.col(field.name()).cast((DataType)StringType$.MODULE$));
    }

    private DeltaWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.delta");
    }
}

