/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.commit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.delta.storage.LogStore;
import io.delta.storage.commit.UpdatedActions;
import io.delta.storage.commit.actions.AbstractMetadata;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class CoordinatedCommitsUtils {
    private static final String LOG_DIR_NAME = "_delta_log";
    private static final String COMMIT_SUBDIR = "_commits";
    private static final String COORDINATED_COMMITS_COORDINATOR_NAME_KEY = "delta.coordinatedCommits.commitCoordinator-preview";
    private static final String COORDINATED_COMMITS_COORDINATOR_CONF_KEY = "delta.coordinatedCommits.commitCoordinatorConf-preview";
    private static final String COORDINATED_COMMITS_TABLE_CONF_KEY = "delta.coordinatedCommits.tableConf-preview";

    private CoordinatedCommitsUtils() {
    }

    public static Path generateUnbackfilledDeltaFilePath(Path path, long l) {
        String string = UUID.randomUUID().toString();
        Path path2 = new Path(path, COMMIT_SUBDIR);
        return new Path(path2, String.format("%020d.%s.json", l, string));
    }

    public static Path getBackfilledDeltaFilePath(Path path, Long l) {
        return new Path(path, String.format("%020d.json", l));
    }

    public static boolean isCoordinatedCommitsToFSConversion(Long l, UpdatedActions updatedActions) {
        boolean bl = CoordinatedCommitsUtils.getCoordinatorName(updatedActions.getOldMetadata()).isPresent();
        boolean bl2 = CoordinatedCommitsUtils.getCoordinatorName(updatedActions.getNewMetadata()).isPresent();
        return bl && !bl2 && l > 0L;
    }

    public static Path getTablePath(Path path) {
        return path.getParent();
    }

    public static Path getUnbackfilledDeltaFile(Path path, long l, Optional<String> optional) {
        Path path2 = CoordinatedCommitsUtils.commitDirPath(path);
        String string = optional.orElse(UUID.randomUUID().toString());
        return new Path(path2, String.format("%020d.%s.json", l, string));
    }

    public static FileStatus writeUnbackfilledCommitFile(LogStore logStore, Configuration configuration, String string, long l, Iterator<String> iterator, String string2) throws IOException {
        Path path = new Path(CoordinatedCommitsUtils.getUnbackfilledDeltaFile(new Path(string), l, Optional.of(string2)).toString());
        logStore.write(path, iterator, true, configuration);
        return path.getFileSystem(configuration).getFileStatus(path);
    }

    public static Path logDirPath(Path path) {
        return new Path(path, LOG_DIR_NAME);
    }

    public static Path commitDirPath(Path path) {
        return new Path(path, COMMIT_SUBDIR);
    }

    public static Optional<String> getCoordinatorName(AbstractMetadata abstractMetadata) {
        String string = abstractMetadata.getConfiguration().get(COORDINATED_COMMITS_COORDINATOR_NAME_KEY);
        return Optional.ofNullable(string);
    }

    private static Map<String, String> parseConfFromMetadata(AbstractMetadata abstractMetadata, String string) {
        String string2 = abstractMetadata.getConfiguration().getOrDefault(string, "{}");
        try {
            return (Map)new ObjectMapper().readValue(string2, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException("Failed to parse conf: ", jsonProcessingException);
        }
    }

    public static Map<String, String> getCoordinatorConf(AbstractMetadata abstractMetadata) {
        return CoordinatedCommitsUtils.parseConfFromMetadata(abstractMetadata, COORDINATED_COMMITS_COORDINATOR_CONF_KEY);
    }

    public static Map<String, String> getTableConf(AbstractMetadata abstractMetadata) {
        return CoordinatedCommitsUtils.parseConfFromMetadata(abstractMetadata, COORDINATED_COMMITS_TABLE_CONF_KEY);
    }
}

