/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonServiceException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathExpression;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathField;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathFlatten;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathProjection;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.ObjectMapperSingleton;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeNatGatewaysResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.AcceptorPathMatcher;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterAcceptor;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterState;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class NatGatewayAvailable {
    NatGatewayAvailable() {
    }

    static class IsNatGatewayNotFoundMatcher
    extends WaiterAcceptor<DescribeNatGatewaysResult> {
        IsNatGatewayNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "NatGatewayNotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsDeletedMatcher
    extends WaiterAcceptor<DescribeNatGatewaysResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletedMatcher() {
        }

        @Override
        public boolean matches(DescribeNatGatewaysResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"deleted\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("NatGateways")), new JmesPathField("State"));
        }
    }

    static class IsDeletingMatcher
    extends WaiterAcceptor<DescribeNatGatewaysResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletingMatcher() {
        }

        @Override
        public boolean matches(DescribeNatGatewaysResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"deleting\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("NatGateways")), new JmesPathField("State"));
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeNatGatewaysResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeNatGatewaysResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("NatGateways")), new JmesPathField("State"));
        }
    }

    static class IsAvailableMatcher
    extends WaiterAcceptor<DescribeNatGatewaysResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsAvailableMatcher() {
        }

        @Override
        public boolean matches(DescribeNatGatewaysResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"available\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("NatGateways")), new JmesPathField("State"));
        }
    }
}

