/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ModelStateHelper;
import com.dataiku.dip.analysis.ml.shared.PRNSTrainThread;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringCoreParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;

public class ClusteringTrainAdditionalThread
extends PRNSTrainThread {
    private ClusteringMLTask task;
    private ResolvedClusteringCoreParams rccp;
    protected static Logger logger = Logger.getLogger((String)"dku.analysis.train");

    public ClusteringTrainAdditionalThread(AuthCtx authCtx, Queue<WorkSet.PreprocessingSet> workQueue, Set<String> fullModelIds, SplitDesc splitDesc, MLTaskLoc taskLoc, ResolvedClusteringCoreParams rccp, String sessionId, Object sync, ClusteringMLTask task) {
        super(authCtx, workQueue, splitDesc, taskLoc, new ArrayList<String>(), sessionId, sync);
        if (fullModelIds != null) {
            this.fullModelIds.addAll(fullModelIds);
        }
        this.task = task;
        this.rccp = rccp;
    }

    @Override
    public String getProjectKey() {
        return this.taskLoc.analysisProjectKey;
    }

    @Override
    public String getEnvName() throws IOException {
        return this.rccp.executionParams.envName;
    }

    @Override
    public ClusteringMLTask getTask() {
        return this.task;
    }

    @Override
    public void process(WorkSet.PreprocessingSet pps) throws Exception {
        if (this.shallNotProcess(pps)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("core_params", this.rccp);
        map.put("preprocessing_set", this.remapPreprocessingSet(pps, this.kernel));
        map.put("split_desc", this.getSplitDesc());
        logger.info((Object)("SUBMITTING " + pps.preprocessingId + " in: " + pps.run_folder + " ; modeling set: " + JSON.json(pps.modelingSets)));
        try {
            pps.link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest("train_clustering_models_nosave", JSON.pretty(map)), null, String.class, "Failed to train").call();
        }
        catch (SocketBlockLinkException e) {
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
        }
    }

    @Override
    protected boolean shallNotProcess(WorkSet.PreprocessingSet pps) {
        String firstFMI = new FullModelId(this.taskLoc, this.sessionId, pps.preprocessingId, pps.modelingSets.get((int)0).modelId).toString();
        return this.fullModelIds != null && !this.fullModelIds.isEmpty() && !this.fullModelIds.contains(firstFMI);
    }

    @Override
    public void postProcess(WorkSet.PreprocessingSet pps) throws IOException {
        ModelStateHelper.updateClusteringTrainInfoAndUserMeta(pps);
    }
}

