/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.guess;

import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuesser;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CustomClusteringGuesser
extends ClusteringGuesser {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.guess");

    public CustomClusteringGuesser(ClusteringMLTask task, MemTable table) {
        super(task, table);
    }

    protected ClusteringModelingParams.ClusteringCustomPythonParams buildDefaultCustomPythonParams() {
        ClusteringModelingParams.ClusteringCustomPythonParams cpp = new ClusteringModelingParams.ClusteringCustomPythonParams();
        cpp.enabled = true;
        cpp.k = new int[]{5};
        cpp.name = "Custom Python model";
        cpp.code = "# This sample code uses a standard scikit-learn algorithm, the Birch clustering.\n\n# Your code must create a 'clf' variable. This clf must be a scikit-learn compatible\n# model, ie, it should:\n#  1. have at least fit(X), fit_predict(X) and predict(X) methods\n#  2. inherit sklearn.base.BaseEstimator\n#  3. handle the attributes in the __init__ function\n#     See: https://doc.dataiku.com/dss/latest/machine-learning/custom-models.html\n\nfrom sklearn.cluster import Birch\n\nclf = Birch(n_clusters=5)\n";
        return cpp;
    }

    protected ClusteringModelingParams guessPythonAlgorithms(boolean keepExistingParams) {
        ClusteringModelingParams params;
        ClusteringModelingParams clusteringModelingParams = params = keepExistingParams ? ((ClusteringMLTask)this.task).modeling : new ClusteringModelingParams();
        if (keepExistingParams && !params.custom_python.isEmpty()) {
            for (ClusteringModelingParams.ClusteringCustomPythonParams customPython : params.custom_python) {
                customPython.enabled = true;
            }
        } else {
            params.custom_python = new ArrayList<ClusteringModelingParams.ClusteringCustomPythonParams>();
            params.custom_python.add(this.buildDefaultCustomPythonParams());
        }
        return params;
    }

    protected PredictionModelingParams.MLLibCustomGridParams buildDefaultMLLibCustomGridParams() {
        PredictionModelingParams.MLLibCustomGridParams mlcgp = new PredictionModelingParams.MLLibCustomGridParams();
        mlcgp.name = "Custom MLlib model";
        mlcgp.enabled = true;
        mlcgp.initializationCode = "// This sample code uses a standard MLlib algorithm, the KMeans.\n\n// import the Estimator from spark.ml\nimport org.apache.spark.ml.clustering.KMeans\n\n// instantiate the Estimator\nnew KMeans()\n  .setFeaturesCol(\"__dku_features\") // Must always be __dku_features\n  .setPredictionCol(\"cluster\") // Must always be cluster\n  .setK(5)\n";
        return mlcgp;
    }

    protected ClusteringModelingParams guessMLLibAlgorithms(boolean keepExistingParams) {
        ClusteringModelingParams params;
        ClusteringModelingParams clusteringModelingParams = params = keepExistingParams ? ((ClusteringMLTask)this.task).modeling : new ClusteringModelingParams();
        if (keepExistingParams && !params.custom_mllib.isEmpty()) {
            for (PredictionModelingParams.MLLibCustomGridParams customMLLib : params.custom_mllib) {
                customMLLib.enabled = true;
            }
        } else {
            params.custom_mllib = new ArrayList<PredictionModelingParams.MLLibCustomGridParams>();
            params.custom_mllib.add(this.buildDefaultMLLibCustomGridParams());
        }
        return params;
    }

    @Override
    public ClusteringModelingParams guessAlgorithms(boolean keepExistingParams) {
        switch (((ClusteringMLTask)this.task).backendType) {
            case MLLIB: {
                return this.guessMLLibAlgorithms(keepExistingParams);
            }
            case PY_MEMORY: {
                return this.guessPythonAlgorithms(keepExistingParams);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)((ClusteringMLTask)this.task).backendType) + " not supported.");
    }
}

