/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.StreamableDatasetSelection;

public class SplitParams {
    public TrainTestPolicy ttPolicy;
    public SplitMode ssdSplitMode = SplitMode.RANDOM;
    public boolean splitBeforePrepare = true;
    public String ssdDatasetSmartName;
    public StreamableDatasetSelection ssdSelection;
    public double ssdTrainingRatio = 0.8;
    public boolean ssdStratified = false;
    public boolean ssdGrouped = false;
    public String ssdGroupColumnName;
    public long ssdSeed = 1337L;
    public String ssdColumn;
    public boolean testOnLargerValues = true;
    public boolean streamAll;
    public String efsdDatasetSmartName;
    public EFSDSplit efsdTrain;
    public EFSDSplit efsdTest;
    public EFTDSplit eftdTrain;
    public EFTDSplit eftdTest;
    public boolean kfold;
    public int nFolds = 5;
    public int instanceIdRefresher;
    public long subSamplingSeed = 1337L;

    public static SplitParams buildStd() {
        SplitParams sp = new SplitParams();
        sp.ttPolicy = TrainTestPolicy.SPLIT_SINGLE_DATASET;
        sp.ssdSelection = StreamableDatasetSelection.head100K();
        sp.ssdSeed = 1337L;
        sp.ssdTrainingRatio = 0.8;
        return sp;
    }

    public static SplitParams buildForTimeseries(String timeVariable) {
        SplitParams sp = new SplitParams();
        sp.ttPolicy = TrainTestPolicy.SPLIT_SINGLE_DATASET;
        sp.ssdSelection = StreamableDatasetSelection.columnOrdered100k(timeVariable, false);
        sp.ssdColumn = timeVariable;
        sp.streamAll = true;
        return sp;
    }

    public static enum SplitMode {
        RANDOM,
        SORTED;

    }

    public static enum TrainTestPolicy {
        SPLIT_SINGLE_DATASET,
        EXPLICIT_FILTERING_SINGLE_DATASET,
        EXPLICIT_FILTERING_TWO_DATASETS;

    }

    public static class EFTDSplit
    extends EFDSplit {
        public String datasetSmartName;
    }

    public static class EFSDSplit
    extends EFDSplit {
    }

    public static class EFDSplit {
        public StreamableDatasetSelection selection;
        public FilterDesc filter;
    }
}

