/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionGlobalExplanationsAbsoluteImportance;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPredictionInfos;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;

public class ClassicalPredictionModelDetails
extends TabularPredictionModelDetails {
    public ResolvedClassicalPredictionCoreParams coreParams;
    public ResolvedClassicalPredictionPreprocessingParams preprocessing;
    public MetricParams.CostMatrixWeights headTaskCMW;
    public PredictionModelPerf perf;
    public PredictionModelPredictionInfos predictionInfo;
    public PredictionModelPredictionInfos referencePredictionInfo;
    public MLAssertionsParams assertionsParams;
    public MLOverridesParams overridesParams;
    public PredictionModelPerf perfWithoutOverrides;
    public PredictionModelIntrinsicPerf iperf;
    public PredictionGlobalExplanationsAbsoluteImportance globalExplanationsAbsoluteImportance;
    public DataEvaluationMetrics dataEvaluationMetrics;
    public long importedOn;
    public String mlflowMLModelFileContent;

    public CompatibilityWithReason getJavaScoreCompatibility() {
        CompatibilityWithReason compat = this.preprocessing.getJavaCompatibility(this.modeling.algorithm.backendType);
        if (!compat.compatible) {
            return compat;
        }
        if (!this.modeling.algorithm.meta.isJavaCompatible(this.coreParams)) {
            return CompatibilityWithReason.nok("Algorithm " + String.valueOf((Object)this.modeling.algorithm) + " is not compatible with Java scoring");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getJavaExportCompatibility() {
        CompatibilityWithReason compat = this.getJavaScoreCompatibility();
        if (!compat.compatible) {
            return compat;
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            CompatibilityWithReason overridesCompat = this.overridesParams.getJavaExportCompatibility();
            if (!overridesCompat.compatible) {
                return overridesCompat;
            }
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getSnowflakeWithJavaUdfCompatibility() {
        CompatibilityWithReason compat = this.getJavaScoreCompatibility();
        if (!compat.compatible) {
            return compat;
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            return CompatibilityWithReason.nok("Models with overrides are not Snowflake with Java UDF compatible");
        }
        if (this.coreParams.isPredictionIntervalEnabled()) {
            return CompatibilityWithReason.nok("Prediction intervals are not compatible with Snowflake with Java UDF scoring");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getSQLCompatibility() {
        CompatibilityWithReason compat = this.preprocessing.getSQLCompatibility(this.modeling.algorithm.backendType, this.coreParams.calibration);
        if (!compat.compatible) {
            return compat;
        }
        if (!this.modeling.algorithm.meta.isSQLCompatible(this.coreParams)) {
            return CompatibilityWithReason.nok("Algorithm " + String.valueOf((Object)this.modeling.algorithm) + " is not compatible with SQL scoring");
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            return CompatibilityWithReason.nok("Models with overrides are not SQL exportable");
        }
        if (this.coreParams.isPredictionIntervalEnabled()) {
            return CompatibilityWithReason.nok("Prediction intervals are not compatible with SQL scoring");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getPMMLCompatibility() {
        CompatibilityWithReason compat = this.preprocessing.getPMMLCompatibility(this.modeling.algorithm.backendType, this.coreParams.calibration);
        if (!compat.compatible) {
            return compat;
        }
        if (!this.modeling.algorithm.meta.isPMMLCompatible()) {
            return CompatibilityWithReason.nok("Algorithm " + String.valueOf((Object)this.modeling.algorithm) + " is not compatible with PMML scoring");
        }
        if (this.coreParams.partitionedModel.isEnabled()) {
            return CompatibilityWithReason.nok("Partitioned models are not compatible with PMML scoring");
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            return CompatibilityWithReason.nok("Models with overrides are not PMML exportable");
        }
        if (this.coreParams.isPredictionIntervalEnabled()) {
            return CompatibilityWithReason.nok("Prediction intervals are not compatible with PMML scoring");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getPythonExportCompatibility() {
        CompatibilityWithReason compat = this.preprocessing.getPythonCompatibility(this.modeling.algorithm.backendType);
        if (!compat.compatible) {
            return compat;
        }
        if (!this.modeling.algorithm.meta.isPythonCompatible(this.coreParams)) {
            return CompatibilityWithReason.nok("Algorithm " + String.valueOf((Object)this.modeling.algorithm) + " is not compatible with Python export");
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            return CompatibilityWithReason.nok("Models with overrides are not Python exportable");
        }
        if (this.coreParams.isPredictionIntervalEnabled()) {
            return CompatibilityWithReason.nok("Prediction intervals are not compatible with Python export");
        }
        return CompatibilityWithReason.ok();
    }

    public CompatibilityWithReason getPythonApiNodeScoreCompatibility() {
        if (!this.backendType.isPythonBased()) {
            return CompatibilityWithReason.nok("Non Python-based models like " + String.valueOf((Object)this.backendType) + " are not compatible with Python scoring");
        }
        if (this.overridesParams != null && this.overridesParams.hasOverrides()) {
            return CompatibilityWithReason.nok("Models with overrides are not compatible with Python scoring on API nodes");
        }
        return this.preprocessing.getPythonApiNodeScoreCompatibility();
    }

    @Override
    public ResolvedClassicalPredictionCoreParams getCoreParams() {
        return this.coreParams;
    }

    @Override
    public ResolvedClassicalPredictionPreprocessingParams getPreprocessing() {
        return this.preprocessing;
    }

    @Override
    public PredictionModelPerf getPerf() {
        return this.perf;
    }
}

