/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesScenariosMetadata;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@UIModel
public class TimeseriesInteractiveScoringScenarios {
    public Map<String, TimeseriesScenarioData> scenarios = new HashMap<String, TimeseriesScenarioData>();
    public TimeseriesScenariosMetadata metadata;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.analysis.ml.timeseries.interactive-scoring");

    public static class InteractiveScenarioFolder {
        private final File folder;
        private final Map<String, String> identifiersMapping;
        private final TimeseriesInteractiveScoringColumnInfo columnInfo;

        public InteractiveScenarioFolder(File modelFolder, ResolvedPreprocessingParams params) throws IOException {
            this.columnInfo = TimeseriesInteractiveScoringColumnInfo.extractTimeseriesColumnInfo(params);
            File interactiveScoringFolder = DKUFileUtils.getWithin((File)modelFolder, (String[])new String[]{"interactive-scoring-analysis"});
            if (!interactiveScoringFolder.exists()) {
                throw new IOException("interactive-scoring-analysis folder does not exist");
            }
            this.folder = interactiveScoringFolder;
            File mappingFile = DKUFileUtils.getWithinFollowLink((File)this.folder, (String[])new String[]{"identifiers_mapping.json"});
            if (!mappingFile.exists()) {
                throw new IOException("identifiers_mapping.json does not exist in interactive-scoring-analysis folder. Updating/Reading scenarios won't be available until scenarios are created");
            }
            TypeToken<Map<String, String>> mapTypeToken = new TypeToken<Map<String, String>>(){};
            this.identifiersMapping = (Map)JSON.parse((InputStream)DKUFileUtils.readWithAutoDecompress((File)mappingFile), (TypeToken)mapTypeToken);
        }

        public Optional<TimeseriesInteractiveScoringScenarios> getIdentifierScenarios(String timeseriesIdentifier) throws IOException {
            TimeseriesScenariosMetadata tsIdentifierMetadata;
            TimeseriesInteractiveScoringScenarios result = new TimeseriesInteractiveScoringScenarios();
            if (!this.identifiersMapping.containsKey(timeseriesIdentifier)) {
                logger.info((Object)("No scenarios for timeseries identifier " + timeseriesIdentifier));
                return Optional.empty();
            }
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            result.metadata = tsIdentifierMetadata = ModelLikeId.parseJsonFile(DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"}), TimeseriesScenariosMetadata.class);
            Set<String> scenarioIds = result.metadata.names.keySet();
            if (scenarioIds.isEmpty()) {
                logger.info((Object)("No scenarios for timeseries identifier " + timeseriesIdentifier));
                return Optional.empty();
            }
            for (String scenarioId : scenarioIds) {
                File scenarioFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-" + scenarioId + ".csv"});
                if (!scenarioFile.exists()) {
                    logger.warn((Object)("scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv does not exist in interactive-scoring-analysis folder for identifier " + timeseriesIdentifier));
                    continue;
                }
                CSVReader reader = new CSVReader((Reader)new InputStreamReader(DKUFileUtils.readWithAutoDecompress((File)scenarioFile)), '\t');
                String[] header = reader.readNext();
                if (header == null) {
                    logger.warn((Object)("Empty scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + timeseriesIdentifier));
                    continue;
                }
                HashMap<String, Integer> headerMapping = new HashMap<String, Integer>();
                for (int i = 0; i < header.length; ++i) {
                    headerMapping.put(header[i], i);
                }
                if (!headerMapping.containsKey(this.columnInfo.dateColumn)) {
                    logger.warn((Object)("Date column " + this.columnInfo.dateColumn + " not found in scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + timeseriesIdentifier));
                    continue;
                }
                if (this.columnInfo.externalFeatureColumns.stream().anyMatch(c2 -> !headerMapping.containsKey(c2))) {
                    logger.warn((Object)("One of external feature columns " + String.valueOf(this.columnInfo.externalFeatureColumns) + " not found in scenario file " + identifierHash + "/scenario-" + scenarioId + ".csv in interactive-scoring-analysis folder for identifier " + timeseriesIdentifier));
                    continue;
                }
                try {
                    String[] row;
                    while ((row = reader.readNext()) != null) {
                        TimeseriesScenarioData scenarioData = result.scenarios.computeIfAbsent(scenarioId, k -> new TimeseriesScenarioData());
                        scenarioData.dates.add(row[(Integer)headerMapping.get(this.columnInfo.dateColumn)]);
                        for (String featCol : this.columnInfo.externalFeatureColumns) {
                            String val = row[(Integer)headerMapping.get(featCol)];
                            scenarioData.externalFeatures.computeIfAbsent(featCol, k -> new ArrayList()).add(val);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception while parsing scenarios for identifier " + timeseriesIdentifier + ": " + e.getMessage()));
                }
            }
            return Optional.of(result);
        }

        public Map<String, TimeseriesInteractiveScoringScenarios> parseScenarios() throws IOException {
            HashMap<String, TimeseriesInteractiveScoringScenarios> result = new HashMap<String, TimeseriesInteractiveScoringScenarios>();
            for (Map.Entry<String, String> entry : this.identifiersMapping.entrySet()) {
                Optional<TimeseriesInteractiveScoringScenarios> identifierScoringScenarios = this.getIdentifierScenarios(entry.getKey());
                if (!identifierScoringScenarios.isPresent()) continue;
                result.put(entry.getKey(), identifierScoringScenarios.get());
            }
            return result;
        }

        public void updateTimeseriesScenarios(String timeseriesIdentifier, TimeseriesInteractiveScoringScenarios perTimeseriesScenarios) throws IOException {
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            if (identifierHash == null) {
                throw new IOException("No hash found in mapping for identifier: " + timeseriesIdentifier);
            }
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            for (Map.Entry<String, TimeseriesScenarioData> scenarioEntry : perTimeseriesScenarios.scenarios.entrySet()) {
                File scenarioFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-" + scenarioEntry.getKey() + ".csv"});
                TimeseriesScenarioData scenarioData = scenarioEntry.getValue();
                scenarioData.writeToCSV(scenarioFile, this.columnInfo.dateColumn);
                logger.info((Object)("Updated scenario " + scenarioEntry.getKey() + "to scenario-" + scenarioEntry.getKey() + ".csv"));
            }
        }

        public void deleteScenario(String timeseriesIdentifier, String scenarioId) throws IOException {
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            if (identifierHash == null) {
                throw new IOException("No hash found in mapping for identifier: " + timeseriesIdentifier);
            }
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            File scenarioFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-" + scenarioId + ".csv"});
            File metadataFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"});
            File scenarioForecastsFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-forecasts-" + scenarioId + ".json.gz"});
            TimeseriesScenariosMetadata tsIdentifiersMetadata = ModelLikeId.parseJsonFile(metadataFile, TimeseriesScenariosMetadata.class);
            tsIdentifiersMetadata.names.remove(scenarioId);
            tsIdentifiersMetadata.colors.remove(scenarioId);
            DKUFileUtils.writeFileUTF8((File)metadataFile, (String)JSON.prettyAsFile((Object)tsIdentifiersMetadata));
            DKUFileUtils.delete((File)scenarioForecastsFile);
            DKUFileUtils.delete((File)scenarioFile);
        }

        public Optional<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts.ScenarioForecasts> getScenarioForecasts(String timeseriesIdentifier, String scenarioId) throws IOException {
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            if (identifierHash == null) {
                throw new IOException("No hash found in mapping for identifier: " + timeseriesIdentifier);
            }
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            File scenarioForecastsFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenario-forecasts-" + scenarioId + ".json.gz"});
            if (!scenarioForecastsFile.exists()) {
                return Optional.empty();
            }
            TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts.ScenarioForecasts result = ModelLikeId.parsePossiblyCompressedJsonFile(scenarioForecastsFile, TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts.ScenarioForecasts.class);
            return Optional.of(result);
        }

        public TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts getScenarioForecasts(String timeseriesIdentifier) throws IOException {
            TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts result = new TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts();
            if (!this.identifiersMapping.containsKey(timeseriesIdentifier)) {
                logger.info((Object)("No scenarios for timeseries identifier " + timeseriesIdentifier));
                return result;
            }
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            TimeseriesScenariosMetadata tsIdentifierMetadata = ModelLikeId.parseJsonFile(DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"}), TimeseriesScenariosMetadata.class);
            Set<String> scenarioIds = tsIdentifierMetadata.names.keySet();
            if (scenarioIds.isEmpty()) {
                logger.info((Object)("No scenarios for timeseries identifier " + timeseriesIdentifier));
                return result;
            }
            for (String scenarioId : scenarioIds) {
                Optional<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts.ScenarioForecasts> scenarioForecasts = this.getScenarioForecasts(timeseriesIdentifier, scenarioId);
                if (!scenarioForecasts.isPresent()) continue;
                result.perScenarios.put(scenarioId, scenarioForecasts.get());
            }
            return result;
        }

        public void renameScenario(String timeseriesIdentifier, String scenarioId, String newScenarioName) throws IOException {
            String identifierHash = this.identifiersMapping.get(timeseriesIdentifier);
            if (identifierHash == null) {
                throw new IOException("No hash found in mapping for identifier: " + timeseriesIdentifier);
            }
            File identifierScenariosFolder = DKUFileUtils.getWithin((File)this.folder, (String[])new String[]{identifierHash});
            File metadataFile = DKUFileUtils.getWithinFollowLink((File)identifierScenariosFolder, (String[])new String[]{"scenarios_metadata.json"});
            TimeseriesScenariosMetadata tsIdentifiersMetadata = ModelLikeId.parseJsonFile(metadataFile, TimeseriesScenariosMetadata.class);
            if (!tsIdentifiersMetadata.names.containsKey(scenarioId)) {
                throw new IOException("No scenario '" + scenarioId + "' exists.");
            }
            if (tsIdentifiersMetadata.names.containsValue(newScenarioName)) {
                throw new IOException("A scenario with the name '" + newScenarioName + "' already exists.");
            }
            tsIdentifiersMetadata.names.put(scenarioId, newScenarioName);
            DKUFileUtils.writeFileUTF8((File)metadataFile, (String)JSON.prettyAsFile((Object)tsIdentifiersMetadata));
        }

        private record TimeseriesInteractiveScoringColumnInfo(String dateColumn, List<String> identifierColumns, List<String> externalFeatureColumns) {
            private static TimeseriesInteractiveScoringColumnInfo extractTimeseriesColumnInfo(ResolvedPreprocessingParams params) {
                Map<String, FeaturePreprocessingParams> features = params.per_feature;
                String dateColumn = null;
                ArrayList<String> identifierColumns = new ArrayList<String>();
                ArrayList<String> externalFeatureColumns = new ArrayList<String>();
                for (Map.Entry<String, FeaturePreprocessingParams> entry : features.entrySet()) {
                    String featureName = entry.getKey();
                    FeaturePreprocessingParams.Role role = entry.getValue().role;
                    switch (role) {
                        case TIME: {
                            dateColumn = featureName;
                            break;
                        }
                        case TIMESERIES_IDENTIFIER: {
                            identifierColumns.add(featureName);
                            break;
                        }
                        case INPUT: {
                            externalFeatureColumns.add(featureName);
                        }
                    }
                }
                return new TimeseriesInteractiveScoringColumnInfo(dateColumn, identifierColumns, externalFeatureColumns);
            }
        }
    }

    public static class TimeseriesScenarioData {
        public List<String> dates = new ArrayList<String>();
        public Map<String, List<String>> externalFeatures = new HashMap<String, List<String>>();

        private String rowToString(List<String> row) {
            return row.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining("\t")) + "\n";
        }

        public void writeToCSV(File scenarioFile, String dateColumn) throws IOException {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> header = new ArrayList<String>();
            header.add(dateColumn);
            header.addAll(this.externalFeatures.keySet());
            sb.append(this.rowToString(header));
            for (int i = 0; i < this.dates.size(); ++i) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(this.dates.get(i));
                for (String featCol : this.externalFeatures.keySet()) {
                    List<String> values = this.externalFeatures.get(featCol);
                    row.add(values != null && i < values.size() ? values.get(i) : "");
                }
                sb.append(this.rowToString(row));
            }
            DKUFileUtils.writeFileUTF8((File)scenarioFile, (String)sb.toString());
        }
    }
}

