/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomScikitMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        if (StringUtils.isNotBlank((String)rpmp.custom_python.name)) {
            return rpmp.custom_python.name;
        }
        Object label = "Custom";
        String[] first_line = rpmp.custom_python.code.split("\n", 2);
        if (first_line.length > 0 && first_line[0].startsWith("\"")) {
            label = (String)label + ": " + first_line[0];
            label = ((String)label).replace("\"", "");
        }
        return label;
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        return new ModelTrainInfo.PreSearchDescription(rpmp);
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        return new ModelTrainInfo.PostSearchDescription();
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        for (PredictionModelingParams.CustomPythonParams cp : pmp.custom_python) {
            if (cp == null || !cp.enabled) continue;
            ErrorContext.checkNotEmpty((String)cp.code, (String)"Custom model is not configured (you must write the code)");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (pmp.custom_python != null) {
            for (PredictionModelingParams.CustomPythonParams cp : pmp.custom_python) {
                if (cp == null || !cp.enabled) continue;
                PreTrainPredictionModelingParams rmcp = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.SCIKIT_MODEL, pmp);
                rmcp.custom_python = cp;
                ret.add(new WorkSet.ModelingSet(rmcp));
            }
        }
        return ret;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return false;
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        return this.getCopyWithGridStrategy(usedToTrain);
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrain = this.regridifyToPreTrain(optimized, usedToTrain);
        target.custom_python.add(preTrain.custom_python);
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.custom_python.add(usedToTrain.custom_python);
    }

    @Override
    public boolean oneModelPerPreprocessingSet() {
        return true;
    }
}

