/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class BuildCodeEnvImagesCommand
extends CLICommand {
    private TransactionService transactionService;
    private CodeEnvUsagesService codeEnvUsagesService;
    private DKUtils.SmartLogTailBuilder logTailBuilder;
    private InfoMessage.InfoMessages ret;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.internalcmd.containers");

    @Override
    public String usageString() {
        return "__build-code-env-images [--all] [--dry-run]";
    }

    @Override
    public String description() {
        return "Build container images for code environment that are in use.";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("a", "all", false, "Build for all code environments, even those are not currently being used.");
        options.addOption("n", "dry-run", false, "Dry run. Only lists code environments that will be updated.");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__build-code-env-images", true);
        Boolean forceBuildForAll = cmdLine.hasOption("all");
        Boolean dryRun = cmdLine.hasOption("dry-run");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        CLISetup.doFullSpringSetupLikeBackend();
        ArrayList<CodeEnvBuildParams> toUpdate = new ArrayList<CodeEnvBuildParams>();
        this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
        this.ret = new InfoMessage.InfoMessages();
        this.codeEnvUsagesService = (CodeEnvUsagesService)SpringUtils.getBean(CodeEnvUsagesService.class);
        this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        List<String> projectKeys = CLISetup.listProjectKeys();
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                AutomationBundlesService automationBundlesService = (AutomationBundlesService)SpringUtils.getBean(AutomationBundlesService.class);
                AutomationNodeCodeEnvsService automationNodeCodeEnvsService = (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
                for (String string : projectKeys) {
                    CommonBundleUtils.BundleDetails bundle;
                    try {
                        bundle = automationBundlesService.getBundleDetails(string, CommonBundleUtils.getActiveBundleId(string));
                    }
                    catch (Exception ex) {
                        logger.errorV("Failed to get active bundle id for %s: %s", new Object[]{string, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
                        continue;
                    }
                    for (CodeEnvModel.UsedCodeEnvRef codeEnv : bundle.exportManifest.usedCodeEnvRefs) {
                        if (!forceBuildForAll.booleanValue() && !this.isCodeEnvUsed(codeEnv.envName, codeEnv.envLang, projectKeys).booleanValue()) continue;
                        try {
                            CodeEnvModel.AutomationEnvRootDef envRootDef = automationNodeCodeEnvsService.getEnvRootDef(codeEnv.envLang, codeEnv.envName);
                            File log = this.getLogFile(automationNodeCodeEnvsService.getEnvLogsDir(codeEnv.envLang, codeEnv.envName));
                            if (envRootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE) {
                                logger.infoV("Found code env '%s' (%s)", new Object[]{codeEnv.envName, codeEnv.envLang});
                                File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(codeEnv.envLang, codeEnv.envName);
                                CodeEnvModel.AbstractEnvDesc envDesc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, codeEnv.envLang.getDescClazz());
                                toUpdate.add(new CodeEnvBuildParams(envRootDef.deploymentMode, codeEnv.envName, codeEnv.envLang, null, envDesc, envRootDir, log));
                                continue;
                            }
                            if (envRootDef.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) continue;
                            logger.infoV("Found code env '%s' (%s)", new Object[]{codeEnv.envName, codeEnv.envLang});
                            CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(codeEnv.envLang, codeEnv.envName, string, bundle.bundleId);
                            File envRootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(codeEnv.envLang, codeEnv.envName, versionRef.envVersion);
                            CodeEnvModel.AbstractEnvDesc envDesc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, codeEnv.envLang.getDescClazz());
                            toUpdate.add(new CodeEnvBuildParams(envRootDef.deploymentMode, codeEnv.envName, codeEnv.envLang, versionRef.envVersion, envDesc, envRootDir, log));
                        }
                        catch (Exception ex) {
                            logger.errorV("Failed to get code env details for '%s' (%s): %s", new Object[]{codeEnv.envName, codeEnv.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
                        }
                    }
                }
                List<CodeEnvModel.CodeEnvListItem> codeEnvList = automationNodeCodeEnvsService.listCodeEnvs();
                for (CodeEnvModel.CodeEnvListItem codeEnv : codeEnvList) {
                    if (codeEnv.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || !forceBuildForAll.booleanValue() && !this.isCodeEnvUsed(codeEnv.envName, codeEnv.envLang, projectKeys).booleanValue()) continue;
                    logger.infoV("Found code env '%s' (%s)", new Object[]{codeEnv.envName, codeEnv.envLang});
                    try {
                        File log = this.getLogFile(automationNodeCodeEnvsService.getEnvLogsDir(codeEnv.envLang, codeEnv.envName));
                        File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(codeEnv.envLang, codeEnv.envName);
                        CodeEnvModel.AbstractEnvDesc envDesc = AutomationNodeManagedEnvUtils.getEnvDesc(envRootDir, codeEnv.envLang.getDescClazz());
                        toUpdate.add(new CodeEnvBuildParams(codeEnv.deploymentMode, codeEnv.envName, codeEnv.envLang, null, envDesc, envRootDir, log));
                    }
                    catch (Exception ex) {
                        logger.errorV("Failed to get code env details for '%s' (%s): %s", new Object[]{codeEnv.envName, codeEnv.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
                    }
                }
                if (dryRun.booleanValue()) {
                    this.stringifyCodeEnvList(toUpdate);
                    break;
                }
                this.updateAutomationNodeContainers(automationNodeCodeEnvsService, toUpdate);
                break;
            }
            case DESIGN: {
                DesignNodeCodeEnvsService designNodeCodeEnvsService = (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
                List<CodeEnvModel.CodeEnvListItem> codeEnvList = designNodeCodeEnvsService.listCodeEnvs();
                logger.infoV("Found %d code envs", new Object[]{codeEnvList.size()});
                for (CodeEnvModel.CodeEnvListItem codeEnvListItem : codeEnvList) {
                    if (codeEnvListItem.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED && codeEnvListItem.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && codeEnvListItem.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL || !forceBuildForAll.booleanValue() && !this.isCodeEnvUsed(codeEnvListItem.envName, codeEnvListItem.envLang, projectKeys).booleanValue()) continue;
                    logger.infoV("Found code env '%s' (%s)", new Object[]{codeEnvListItem.envName, codeEnvListItem.envLang});
                    try {
                        File log = this.getLogFile(designNodeCodeEnvsService.getEnvLogsDir(codeEnvListItem.envLang, codeEnvListItem.envName));
                        CodeEnvModel.AbstractEnvDesc envDesc = designNodeCodeEnvsService.getEnvDesc(codeEnvListItem.envLang, codeEnvListItem.envName);
                        toUpdate.add(new CodeEnvBuildParams(codeEnvListItem.deploymentMode, codeEnvListItem.envName, codeEnvListItem.envLang, null, envDesc, null, log));
                    }
                    catch (Exception ex) {
                        logger.errorV("Failed to get code env details for '%s' (%s): %s", new Object[]{codeEnvListItem.envName, codeEnvListItem.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
                    }
                }
                if (dryRun.booleanValue()) {
                    this.stringifyCodeEnvList(toUpdate);
                    break;
                }
                this.updateDesignNodeContainers(designNodeCodeEnvsService, toUpdate);
                break;
            }
            default: {
                throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
            }
        }
        return 0;
    }

    private File getLogFile(File envLogsDir) throws IOException {
        File log = ApplicationConfigurator.getFile((File)envLogsDir, (String[])new String[]{"containerUpdate.log"});
        DKUFileUtils.mkdirsParent((File)log);
        return log;
    }

    private Boolean isCodeEnvUsed(String envName, CodeEnvModel.EnvLang envLang, List<String> projectKeys) {
        Boolean bl;
        block8: {
            Transaction ignored = this.transactionService.beginRead();
            try {
                bl = !this.codeEnvUsagesService.listUsages(new CodeEnvModel.UsedCodeEnvRef(envLang, envName), projectKeys).isEmpty();
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.warnV((Throwable)ex, "Failed to get code env usages for '%s' (%s)", new Object[]{envName, envLang});
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    private void updateAutomationNodeContainers(AutomationNodeCodeEnvsService automationNodeCodeEnvsService, List<CodeEnvBuildParams> toUpdate) {
        for (CodeEnvBuildParams codeEnv : toUpdate) {
            try {
                logger.infoV("Building '%s' (%s)", new Object[]{codeEnv.envName, codeEnv.envLang});
                automationNodeCodeEnvsService.buildEnvDockerImages(codeEnv.versionDescFolder, codeEnv.envDesc, codeEnv.envLang, this.logTailBuilder, codeEnv.log, codeEnv.envName, codeEnv.envVersion, this.ret);
            }
            catch (Exception ex) {
                logger.errorV("Failed to build '%s' (%s): %s", new Object[]{codeEnv.envName, codeEnv.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
            }
        }
    }

    private void updateDesignNodeContainers(DesignNodeCodeEnvsService designNodeCodeEnvsService, List<CodeEnvBuildParams> toUpdate) {
        for (CodeEnvBuildParams codeEnv : toUpdate) {
            try {
                logger.infoV("Building '%s' (%s)", new Object[]{codeEnv.envName, codeEnv.envLang});
                designNodeCodeEnvsService.buildEnvDockerImage(codeEnv.envDesc, codeEnv.envLang, codeEnv.envName, this.logTailBuilder, codeEnv.log, this.ret, false);
            }
            catch (Exception ex) {
                logger.errorV("Failed to build '%s' (%s): %s", new Object[]{codeEnv.envName, codeEnv.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
            }
        }
    }

    private void stringifyCodeEnvList(List<CodeEnvBuildParams> codeEnvList) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dry run - the container images would have been updated for the following code environments:\n");
        for (CodeEnvBuildParams codeEnv : codeEnvList) {
            sb.append(String.format("- %s (%s, %s) %s \n", new Object[]{codeEnv.envName, codeEnv.envLang, codeEnv.deploymentMode, Objects.toString(codeEnv.envVersion, "")}));
        }
        logger.info((Object)sb.toString());
    }

    private class CodeEnvBuildParams {
        CodeEnvModel.CodeEnvDeploymentMode deploymentMode;
        String envName;
        CodeEnvModel.EnvLang envLang;
        String envVersion;
        CodeEnvModel.AbstractEnvDesc envDesc;
        File versionDescFolder;
        File log;

        public CodeEnvBuildParams(CodeEnvModel.CodeEnvDeploymentMode deploymentMode, String envName, CodeEnvModel.EnvLang envLang, String envVersion, CodeEnvModel.AbstractEnvDesc envDesc, File versionDescFolder, File log) {
            this.deploymentMode = deploymentMode;
            this.envName = envName;
            this.envLang = envLang;
            this.envVersion = envVersion;
            this.envDesc = envDesc;
            this.versionDescFolder = versionDescFolder;
            this.log = log;
        }
    }
}

