/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.exceptions.UnavailableTypeException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedCodeStudioTemplatesDAO
implements CodeStudioTemplatesDAO {
    public static final String CONFIG_FOLDER = "code_studio_templates";
    static DKULogger logger = DKULogger.getLogger((String)"dku.codestudio.templates.dao");

    private RelFile getCodeStudioTemplateFolder() {
        return new RelFile(new String[]{CONFIG_FOLDER});
    }

    private RelFile getCodeStudioTemplateFile(String id) {
        return new RelFile(new String[]{CONFIG_FOLDER, id + ".json"});
    }

    @Override
    public CodeStudioTemplate getOrNull(String id) throws IOException {
        return this.getOrNull(id, false);
    }

    @Override
    public CodeStudioTemplate getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id, true);
    }

    @Override
    public CodeStudioTemplate getMandatory(String id) throws IOException {
        return this.getMandatory(id, false);
    }

    @Override
    public CodeStudioTemplate getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id, true);
    }

    private CodeStudioTemplate getMandatory(String id, boolean unsafe) throws IOException {
        CodeStudioTemplate obj = this.getOrNull(id, unsafe);
        if (obj == null) {
            throw new NotFoundException("CodeStudioTemplate does not exist: " + id);
        }
        return obj;
    }

    private CodeStudioTemplate getOrNull(String id, boolean unsafe) throws IOException {
        RelFile codeStudioTemplateFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(codeStudioTemplateFile = this.getCodeStudioTemplateFile(id))) {
            return null;
        }
        CodeStudioTemplate codeStudioTemplate = unsafe ? (CodeStudioTemplate)t.readObjectUnsafe(codeStudioTemplateFile, CodeStudioTemplate.class) : (CodeStudioTemplate)t.readObject(codeStudioTemplateFile, CodeStudioTemplate.class);
        codeStudioTemplate.id = id;
        return codeStudioTemplate;
    }

    @Override
    public void delete(String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile codeStudioTemplateFile = this.getCodeStudioTemplateFile(id);
        t.deleteFile(codeStudioTemplateFile);
    }

    @Override
    public List<CodeStudioTemplate> list() throws IOException {
        return this.list(false);
    }

    @Override
    public List<CodeStudioTemplate> listUnsafe() throws IOException {
        return this.list(true);
    }

    private List<CodeStudioTemplate> list(boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile codeStudioTemplateFolder = this.getCodeStudioTemplateFolder();
        ArrayList<CodeStudioTemplate> ret = new ArrayList<CodeStudioTemplate>();
        if (t.exists(codeStudioTemplateFolder)) {
            for (RelFile f : t.listFiles(codeStudioTemplateFolder, (RelFileFilter)ExtensionFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    ret.add(this.getMandatory(id, unsafe));
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read code_studio_template file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public List<String> listMissingTypes() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile codeStudioTemplateFolder = this.getCodeStudioTemplateFolder();
        ArrayList<String> ret = new ArrayList<String>();
        if (t.exists(codeStudioTemplateFolder)) {
            for (RelFile f : t.listFiles(codeStudioTemplateFolder, (RelFileFilter)ExtensionFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    this.getMandatory(id, true);
                }
                catch (UnavailableTypeException ute) {
                    ret.add(ute.missingType);
                }
                catch (UnavailableDSSObjectException udoe) {
                    ret.add(udoe.unavailableStepInfo.elementId);
                }
            }
        }
        return ret;
    }

    @Override
    public int approximateCount() throws IOException {
        RelFile codeStudioTemplateFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(codeStudioTemplateFolder = this.getCodeStudioTemplateFolder())) {
            return 0;
        }
        return t.listFiles(codeStudioTemplateFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void save(CodeStudioTemplate codeStudioTemplate) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile codeStudioTemplateFile = this.getCodeStudioTemplateFile(codeStudioTemplate.id);
        t.writeObject(codeStudioTemplateFile, (Object)codeStudioTemplate);
    }
}

