/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ManualDatasetsDAO
extends AbstractStandardDAO<SerializedDataset>
implements DatasetsDAO {
    public Map<String, Dataset> map = new HashMap<String, Dataset>();
    public Set<String> caseInsensitiveNames = new HashSet<String>();

    public ManualDatasetsDAO() {
    }

    public ManualDatasetsDAO(Dataset ... objs) {
        for (Dataset dataset : objs) {
            this.set(dataset.getName(), dataset);
        }
    }

    @Deprecated
    public void set(String name, Dataset dataset) {
        this.map.put(name, dataset);
        this.caseInsensitiveNames.add(name.toLowerCase());
    }

    @Override
    public void save(SerializedDataset sd) {
        this.set(sd.getFullName(), Dataset.fromSerialized(sd));
    }

    @Override
    public void delete(String projectKey, String name) throws IOException {
    }

    @Override
    public List<SerializedDataset> list_noTag(String projectKey, boolean unsafe) throws IOException {
        return this.map.values().stream().filter(dataset -> projectKey.equals(dataset.getProjectKey())).map(Dataset::serialize).collect(Collectors.toList());
    }

    @Override
    public SerializedDataset getOrNull_noTag(String projectKey, String name, boolean unsafe) throws IOException {
        Dataset dataset;
        Dataset dataset2 = dataset = this.map.containsKey(projectKey + "." + name) ? this.map.get(projectKey + "." + name) : this.map.get(name);
        if (dataset == null) {
            this.logger.error((Object)("MDAO: not found " + projectKey + "." + name));
            return null;
        }
        dataset.setFullName(projectKey + "." + name);
        return dataset.serialize();
    }

    @Override
    public boolean datasetExistsCaseInsensitive(String projectKey, String name) {
        return this.caseInsensitiveNames.contains(name);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        return 0;
    }

    @Override
    public boolean exists(String projectKey, String id) {
        return this.map.containsKey(id);
    }

    @Override
    public List<String> listUsedNames(String projectKey) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void rename(String projectKey, String oldName, String newName) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.DATASET.toHumanReadableString();
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        throw new NotImplementedException("ManualDatasetsDAO does not manage files");
    }
}

