/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dashboards.export.execution.DashboardEnrichedExport;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.execution.ExportScriptRunner;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DashboardExportScriptRunner
extends ExportScriptRunner {
    public DashboardExportScriptRunner(DashboardEnrichedExport export, File exportDirectory, InternalAPIKeysService.APIKey apiKey, final FutureProgressState progressState) {
        super(export, exportDirectory, apiKey);
        ExportScriptRunner.ExportProgressObserver progressObserver = new ExportScriptRunner.ExportProgressObserver(){

            @Override
            public void update(int exportedCount) throws InterruptedException {
                progressState.set((double)exportedCount);
            }
        };
        ExportScriptRunner.ProgressSubscription progressSubscription = new ExportScriptRunner.ProgressSubscription(progressObserver, this.getLogProgressMarker());
        this.outputSubscriptions.add(progressSubscription);
    }

    @Override
    protected String getScriptFileName() {
        return "export-dashboards.js";
    }

    @Override
    protected ExportScriptRunner.ScriptConfig getScriptConfig() {
        Config result = new Config();
        result.urlsRequiringAuthentication = this.getUrlsRequiringAuthentication();
        result.browserSandBoxing = this.export.browserSandBoxing;
        result.pageDefaultTimeout = ApplicationConfigurator.getProperty((String)"dku.exports.puppeteer.pageDefaultTimeout", (int)0);
        result.outputDirectory = this.exportDirectory.getAbsolutePath();
        result.fileType = String.valueOf((Object)this.export.format.fileType);
        result.width = String.valueOf(this.export.format.width);
        result.height = String.valueOf(this.export.format.height);
        result.dashboards = new ArrayList<Dashboard>();
        for (DashboardEnrichedExport.EnrichedDashboardExportTarget item : ((DashboardEnrichedExport)this.export).dashboards) {
            String dashboardId = item.dashboardId;
            String url = item.url;
            String slideIndex = item.slideIndex == null ? "ALL" : String.valueOf(item.slideIndex);
            result.dashboards.add(new Dashboard(dashboardId, url, slideIndex, item.filtersBySlide));
        }
        return result;
    }

    @Override
    protected String getLogProgressMarker() {
        return "Successfully exported dashboard";
    }

    private static class Config
    extends ExportScriptRunner.ScriptConfig {
        public String fileType;
        public String width;
        public String height;
        public List<Dashboard> dashboards;

        private Config() {
        }
    }

    private static class Dashboard {
        public String id;
        public String url;
        public String slideIndex;
        public List<String> filtersBySlide;

        public Dashboard(String id, String url, String slideIndex, List<String> filtersBySlide) {
            this.id = id;
            this.url = url;
            this.slideIndex = slideIndex;
            this.filtersBySlide = filtersBySlide;
        }
    }
}

