/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedRecipeRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractJuliaRecipeRunner
extends AbstractCodeBasedRecipeRunner {
    private static Logger logger = Logger.getLogger((String)"dku.flow.abstract.julia");

    public AbstractJuliaRecipeRunner(JobActivity activity) {
        super(activity);
    }

    protected List<String> getJuliaCmd(File precompiledImage, String wrapperPath, String scriptPath) {
        ArrayList<String> cmd = new ArrayList<String>();
        String juliaBin = System.getenv("DKUJULIABIN");
        if (juliaBin == null) {
            throw new Error("Environment variable DKUJULIABIN not defined. Make sure the julia integration has been installed on this instance.");
        }
        logger.info((Object)("julia executable : " + juliaBin));
        cmd.add(juliaBin);
        if (precompiledImage.isFile()) {
            logger.info((Object)("Sysimage used : " + precompiledImage.getAbsolutePath()));
            cmd.add("-J");
            cmd.add(precompiledImage.getAbsolutePath());
        } else {
            logger.info((Object)"No sysimage found, default julia sysimage used.");
        }
        cmd.add(wrapperPath);
        cmd.add(scriptPath);
        return cmd;
    }

    protected void executeScript(File recipeTmpDir, String jlScriptData, String envName) throws Exception {
        File logFile = FlowJobUtils.getJobTouchedFile("julia-recipe", "process-out.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Julia output", logFile, "text/plain");
        File tmpScriptData = new File(recipeTmpDir, "script.jl");
        logger.info((Object)("Dumping Julia script to " + String.valueOf(tmpScriptData)));
        DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)jlScriptData);
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/julia-exec-wrapper.jl");
        File wrapperFile = new File(recipeTmpDir, "julia-exec-wrapper.jl");
        DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
        this.writeRemoteRunEnvDefForLocalExecution(recipeTmpDir, envName);
        String juliaDepot = System.getenv("DKUJULIADEPOT");
        if (juliaDepot == null) {
            throw new Error("Environment variable DKUJULIADEPOT not defined. Make sure the julia integration has been installed on this instance.");
        }
        logger.info((Object)("julia depot path : " + juliaDepot));
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Map<String, String> environment = builder.environment();
        environment.put("JULIA_DEPOT_PATH", juliaDepot);
        builder.directory(recipeTmpDir);
        builder.command(this.getJuliaCmd(new File(juliaDepot, "dku-sysimg.so"), wrapperFile.getAbsolutePath(), tmpScriptData.getAbsolutePath()));
        this.execute(builder, logFile, null, "Julia", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false);
    }
}

