/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;

public class EuclideanMatcher
extends Matcher {
    public EuclideanMatcher(double threshold, Integer relativeTo, boolean debugMode) {
        super(threshold, relativeTo, debugMode);
    }

    @Override
    protected boolean isValidInputs(String queryString, String candidateString) {
        try {
            double query = Double.parseDouble(queryString);
            double candidate = Double.parseDouble(candidateString);
            return !Double.isInfinite(query) && !Double.isInfinite(candidate);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected double computeDistance(String queryString, String candidateString) {
        double query = Double.parseDouble(queryString);
        double candidate = Double.parseDouble(candidateString);
        return Math.abs(query - candidate);
    }

    @Override
    protected double computeNormalisationFactor(String queryString, String candidateString) {
        if (this.relativeTo == null) {
            return 1.0;
        }
        double query = Double.parseDouble(queryString);
        double candidate = Double.parseDouble(candidateString);
        return this.relativeTo == 0 ? query : candidate;
    }

    @Override
    protected FuzzyJoinRecipePayloadParams.DistanceType getDistanceType() {
        return FuzzyJoinRecipePayloadParams.DistanceType.EUCLIDEAN;
    }
}

