/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobDef;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipeModalityCollectionJobDefBuilder {
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final PivotRecipeModalityCollectionJobDef serialized = new PivotRecipeModalityCollectionJobDef();
    @Autowired
    private DatasetsDAO datasetsDAO;
    private static final Logger logger = Logger.getLogger((String)"dku.spark.sparkpivot");

    public PivotRecipeModalityCollectionJobDefBuilder(JobActivity activity) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
    }

    public PivotRecipeModalityCollectionJobDef build() {
        return this.serialized;
    }

    public PivotRecipeModalityCollectionJobDefBuilder withInput(boolean useGlobalMetastore, InputDatasetsReadParams readParams) throws IOException {
        this.serialized.readParams = (InputDatasetsReadParams)JSON.deepCopy((Object)readParams);
        this.serialized.input = this.setupInput(this.activity.getSubgraph().getSingleSourceDataset(), this.serialized.readParams, useGlobalMetastore);
        this.serialized.useGlobalMetastore = useGlobalMetastore;
        if (useGlobalMetastore) {
            this.serialized.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (this.serialized.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                this.serialized.metastoreDatabase = "";
            }
        }
        return this;
    }

    public PivotRecipeModalityCollectionJobDefBuilder withCollection(int pivotIndex, String sql, PivotElement pivotElement) {
        PivotRecipeModalityCollectionJobDef.PivotRecipeModalityCollectionDef collectionDef = new PivotRecipeModalityCollectionJobDef.PivotRecipeModalityCollectionDef();
        this.serialized.modalityCollectionDefs.add(collectionDef);
        collectionDef.pivotIndex = pivotIndex;
        collectionDef.sqlQuery = sql;
        collectionDef.keyColumns = pivotElement.keyColumns;
        return this;
    }

    private FlowDatasetRef setupInput(FlowDataset in, InputDatasetsReadParams readParams, boolean useGlobalMetastore) throws IOException {
        return SparkRecipeUtils.getInputFlowDatasetRef(in, readParams, useGlobalMetastore, this.recipe, this.activity, this.datasetsDAO);
    }
}

