/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeBuiltinRunner;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeService;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.factory.annotation.Autowired;

public class VStackRecipeRunner
extends MultiEngineRecipeRunner
implements ContainerizedDSSEngineAble {
    @Autowired
    private VStackRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    protected VStackRecipePayloadParams params;
    private boolean isRunningInContainer = false;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.vstack");

    public VStackRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD: " + payload));
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    protected String generateSQL(SQLDialect dialect) throws Exception {
        return this.service.generateSQL(this.activity, dialect, this.params, false);
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    protected void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine) throws Exception {
        if (this.params.postFilter != null && this.params.postFilter.distinct) {
            this.activity.warnContext.addWarning(null, "'Distinct' option in post-filter is not available for this type of datasets. Rows will not be deduplicated.", logger);
        }
        for (VStackRecipePayloadParams.InputDesc vi : this.params.virtualInputs) {
            if (vi.preFilter == null || !vi.preFilter.distinct) continue;
            this.activity.warnContext.addWarning(null, "'Distinct' option in pre-filter may be skipped with these input datasets, check the output.", logger);
        }
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedStreamEngineExecutor containerizedRunner = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.executor = containerizedRunner;
        } else {
            VStackRecipeBuiltinRunner dssRunner = new VStackRecipeBuiltinRunner(this.activity);
            dssRunner.params = this.params;
            SpringUtils.getInstance().autowire((Object)dssRunner);
            this.executor = dssRunner;
        }
    }
}

