/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.DefaultActivityLifecycleHook;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.FinalCommitable;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunnableThreadsHolder;
import com.dataiku.dip.dataflow.jobrunner.ExecutionRunnablesBuilder;
import com.dataiku.dip.dataflow.jobrunner.FlowRunnableUtils;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.slave.JobKernelAPIClient;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.SourceDatasetNotReadyException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.intercom.t.JobsIntercomController;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityRunner
extends ActivityRunnableThreadsHolder {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private ProjectsDAO projectsDAO;
    private JobActivity activity;
    private boolean abortNotified;
    private final JobDef jobDef;
    private SerializedRecipe.RecipeHashPropagationBehavior hashPropagationBehavior = null;
    private final JobKernelAPIClient apiClient;
    private List<FlowRunnable> additionalRunnables = new ArrayList<FlowRunnable>();
    FutureAborter aborter = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.activity");

    public ActivityRunner(JobDef jobDef, JobActivity activity, APITicketService apiTicketService) {
        this.jobDef = jobDef;
        this.activity = activity;
        this.apiClient = new JobKernelAPIClient(apiTicketService);
    }

    public synchronized JobActivity getActivity() {
        return this.activity;
    }

    private boolean waitForEnd(PeriodicObserver observer) throws IOException {
        boolean clearSamples;
        boolean success;
        block51: {
            logger.debug((Object)"Execution threads started, waiting for activity end");
            while (true) {
                int aliveThreads = 0;
                for (FlowRunnableThread flowRunnableThread : this.getRunnableThreads()) {
                    if (!flowRunnableThread.isAlive()) continue;
                    ++aliveThreads;
                }
                this.activity.aliveThreads = aliveThreads;
                if (aliveThreads <= 0) break;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(aliveThreads + " threads still alive"));
                }
                try {
                    if (observer != null) {
                        observer.onInterval();
                    }
                }
                catch (Exception e2) {
                    logger.warn((Object)"Periodic observer failed", (Throwable)e2);
                }
                DKUtils.unsafeSleep((long)25L);
            }
            logger.info((Object)"activity is finished");
            success = true;
            for (FlowRunnableThread frt : this.getRunnableThreads()) {
                if (frt.storedException == null) continue;
                logger.error((Object)"Activity failed", frt.storedException);
                success = false;
                this.activity.firstFailure = frt.storedException;
                break;
            }
            ActivityRunnableThreadsHolder.clearCurrentActivityRunnableThreadsHolder();
            logger.info((Object)"Executing default post-activity lifecycle hook");
            DefaultActivityLifecycleHook defaultActivityLifecycleHook = new DefaultActivityLifecycleHook(this.activity);
            try {
                defaultActivityLifecycleHook.onPostActivity();
            }
            catch (Exception e3) {
                logger.warn((Object)"Post-activity hook failed, permissions might be incorrect", (Throwable)e3);
            }
            if (success) {
                try {
                    JobContext jc = JobContext.getCurrentJobContext();
                    ClusterSettings clusterSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), jc.projectKey);
                    if (!MetastoreSynchronizationUtils.isSynchronizationPossible(clusterSettings)) break block51;
                    JobDef jobDef = (JobDef)JSON.parseFile((File)FlowJobUtils.jobDefFile(false, jc.projectKey, jc.jobId), JobDef.class);
                    if (!jobDef.refreshHiveMetastore) break block51;
                    try (HiveMetastoreSynchronizer sync = HiveMetastoreSynchronizerFactory.getSynchronizer(this.authCtxService.getAuthCtx());){
                        for (FlowDataset target : this.activity.getSubgraph().getTargetsDatasets()) {
                            Dataset ds = target.getMandatory(this.datasetsDAO);
                            if (!DatasetInspector.isMetastoreAssociatedType(ds)) continue;
                            MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(this.authCtxService.getAuthCtx(), ds);
                            if (requestedStatus.requested) {
                                try {
                                    sync.synchronizeOneDatasetPartition(target.getMandatory(this.datasetsDAO), this.activity.getSubgraph().getTargetPartition(target), false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, this.activity.warnContext, true);
                                }
                                catch (Exception e4) {
                                    this.activity.warnContext.addWarning(WarningsContext.WarningType.HIVE_METASTORE_SYNCHRONIZE, String.format("Failed to synchronize Hive metastore for dataset %s", ds.getFullName()), (Throwable)e4, logger);
                                }
                                continue;
                            }
                            logger.infoV("Not synchronizing metastore for %s, not requested for dataset (%s)", new Object[]{ds.getFullName(), requestedStatus.reason});
                        }
                    }
                }
                catch (Exception e5) {
                    throw new RuntimeException("Unexpected exception while handling Metastore synchronization", e5);
                }
            }
        }
        SerializedProject jobDefProject = this.projectsDAO.getMandatoryUnsafe(this.jobDef.projectKey);
        boolean computeMetricsAfterBuild = ConnectionUtils.getParamsFromProperties(jobDefProject.settings.dkuProperties).getBoolParam("dku.metrics.computeMetricsAfterBuild", true);
        if (success && computeMetricsAfterBuild) {
            logger.info((Object)"Activity successful, computing metrics and running checks or Data Quality rules");
            try {
                JobsIntercomController.ActivityChecksResults checksReport = this.apiClient.runChecksForActivity(this.jobDef, this.activity.getStatus());
                logger.info((Object)("Activity checks and Data Quality rules produced " + checksReport.count + " value" + (checksReport.count > 1 ? "s" : "")));
                if (checksReport.warningCount > 0) {
                    logger.warn((Object)("Activity checks and Data Quality rules produced " + checksReport.warningCount + " warning" + (checksReport.warningCount > 1 ? "s" : "")));
                    checksReport.warnings.forEach(e -> logger.warn(e));
                }
                if (checksReport.ignoredErrorCount > 0) {
                    logger.warn((Object)("Activity checks and Data Quality rules produced " + checksReport.ignoredErrorCount + " error" + (checksReport.ignoredErrorCount > 1 ? "s" : "") + " on datasets with the option to allow build to continue."));
                    checksReport.warnings.forEach(e -> logger.warn(e));
                }
                if (checksReport.errorCount > 0) {
                    logger.error((Object)("Activity checks and Data Quality rules produced " + checksReport.errorCount + " error" + (checksReport.errorCount > 1 ? "s" : "")));
                    checksReport.errors.forEach(e -> logger.error(e));
                    this.activity.firstFailure = new JobsIntercomController.CheckFailedException("Activity checks and Data Quality rules produced " + checksReport.errorCount + " error" + (checksReport.errorCount > 1 ? "s" : "") + " on datasets without the option to allow build to continue.");
                    success = false;
                }
                if (!checksReport.computationFailuresDetails.isEmpty()) {
                    logger.error((Object)"Activity checks and Data Quality rules encountered some errors while running:");
                    checksReport.computationFailuresDetails.forEach((partition, errors) -> errors.forEach(error -> {
                        if (error.ruleName == null) {
                            logger.error((Object)String.format("Error during metric computation on partition %s:", partition));
                        } else {
                            logger.error((Object)String.format("Error during %s '%s' computation on partition %s:", error.isAboutDataQualityRules ? "rule" : "check", error.ruleName, partition));
                        }
                        logger.info((Object)String.format("%s: %s", error.clazz, error.message));
                        logger.info((Object)String.format("Stacktrace:%n%s", error.stacktrace));
                        if (!error.logs.isEmpty()) {
                            logger.info((Object)String.format("Logs:%n%s", String.join((CharSequence)",", error.logs)));
                        }
                    }));
                }
            }
            catch (IOException e6) {
                logger.error((Object)"Failed to run checks or Data Quality rules for activity", (Throwable)e6);
                success = false;
            }
        }
        if (success) {
            for (FlowRunnableThread frt : this.getRunnableThreads()) {
                if (!(frt.runnable instanceof FinalCommitable)) continue;
                logger.info((Object)("Activity successful, final-committing: " + String.valueOf(frt)));
                try {
                    ((FinalCommitable)((Object)frt.runnable)).finalCommit();
                }
                catch (Exception e7) {
                    success = false;
                    this.activity.firstFailure = e7;
                    break;
                }
            }
        }
        try {
            if (observer != null) {
                observer.onEnd(success);
            }
        }
        catch (Exception e8) {
            logger.error((Object)"End observer failed", (Throwable)e8);
        }
        if (success) {
            try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
                if (this.hashPropagationBehavior == SerializedRecipe.RecipeHashPropagationBehavior.DISABLED) {
                    logger.info((Object)"Activity is successful, but hash propagation is disabled");
                } else {
                    logger.info((Object)"Activity is successful, computing timestamps to propagate");
                    this.computeTimestampsToPropagateAfterActivity();
                    logger.infoV("Activity is successful, propagating %d timestamps", new Object[]{this.activity.getSubgraph().hashToPropagate.size()});
                    this.flowStateInternalDB.propagateHashes(conn, this.activity.getSubgraph().hashToPropagate);
                }
            }
            catch (Exception e9) {
                logger.error((Object)"Failed to propagate timestamps", (Throwable)e9);
            }
        }
        if (clearSamples = ConnectionUtils.getParamsFromProperties(jobDefProject.settings.dkuProperties).getBoolParam("dku.jobs.synchronousClearSamples", true)) {
            for (FlowDataset target : this.activity.getSubgraph().getTargetsDatasets()) {
                try {
                    this.apiClient.postFormToStringV("/dip/api/tintercom/datasets/clear-samples", new Object[]{"fullDatasetName", target.getFullName()});
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(target.getFullName());
                    File linoCacheDir = ApplicationConfigurator.getFile((String)("caches/shaker-full-pivot-lino/" + loc.getProjectKey() + "_" + loc.getName()));
                    if (!linoCacheDir.isDirectory()) continue;
                    DKUFileUtils.deleteDirectory((File)linoCacheDir);
                }
                catch (Exception e10) {
                    logger.error((Object)("Failed to clear timestamps for " + target.getFullName()), (Throwable)e10);
                }
            }
        }
        logger.info((Object)"Done post-activity tasks");
        this.activity.stopTimers();
        this.activity.setStatusMessage(null, null, null);
        this.activity.endTime = System.currentTimeMillis();
        this.activity.runSummary.totalTime = this.activity.endTime - this.activity.startTime;
        logger.info((Object)"done handling times");
        return success;
    }

    public synchronized void registerAdditionalRunnable(FlowRunnable additional) {
        this.additionalRunnables.add(additional);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbort() {
        ArrayList<FlowRunnable> additionals;
        ArrayList<FlowRunnableThread> frts;
        ActivityRunner activityRunner = this;
        synchronized (activityRunner) {
            if (this.aborter != null) {
                this.aborter.abort();
            }
        }
        ActivityRunner activityRunner2 = this;
        synchronized (activityRunner2) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            frts = new ArrayList<FlowRunnableThread>(this.getRunnableThreads());
            additionals = new ArrayList<FlowRunnable>(this.additionalRunnables);
        }
        FlowRunnableUtils.abort(frts, additionals, DKUApp.getParams().getIntParam("dku.flow.activity.abort.poolSize", Integer.valueOf(1)));
    }

    private void checkSourcesReady(Map<String, DatasetReadiness> sourcePartitionHashMap) throws Exception {
        ComputableHashComputer dhc = new ComputableHashComputer(TransactionContext.retrieveWrite().getUser());
        dhc.allowUseOfSession();
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            for (FlowComputable flowComputable : this.activity.getSubgraph().getSources()) {
                List<Partition> sourceParts = null;
                switch (flowComputable.getType()) {
                    case DATASET: 
                    case MANAGED_FOLDER: 
                    case SAVED_MODEL: 
                    case RETRIEVABLE_KNOWLEDGE: 
                    case MODEL_EVALUATION_STORE: {
                        sourceParts = this.activity.getSubgraph().getSourcePartitions(flowComputable);
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        throw new IllegalStateException("Streaming endpoints are not built");
                    }
                }
                block14: for (Partition sourceP : sourceParts) {
                    logger.info((Object)("Will check readiness of " + flowComputable.getFullId() + " p=" + sourceP.id()));
                    DatasetReadiness sourcePartitionHash = dhc.getCurrentContentHash(conn, flowComputable, sourceP);
                    sourcePartitionHashMap.put(this.createCacheKey(flowComputable, sourceP), sourcePartitionHash);
                    logger.info((Object)("Checked source readiness " + flowComputable.getFullId() + " -> " + sourcePartitionHash.isReady()));
                    if (sourcePartitionHash.isReady()) continue;
                    switch (this.hashPropagationBehavior) {
                        case INHERIT: 
                        case DISABLED: {
                            throw new Error("unreachable");
                        }
                        case ENABLED_BUT_IGNORE_NON_READY_SOURCES: {
                            logger.infoV("Ignoring non-ready source --> skipping %s/%s", new Object[]{flowComputable.getFullId(), sourceP.id()});
                            continue block14;
                        }
                    }
                    if (flowComputable instanceof FlowPartitionable) {
                        Partitionable sourceDataset = ((FlowPartitionable)((Object)flowComputable)).getPartitioned(this.datasetsDAO);
                        if (sourceDataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                            this.activity.warnContext.addWarning(WarningsContext.WarningType.MISSING_SOURCE_PARTITION, String.format("Partition %s of source %s was missing, considering it as empty", sourceP.id(), flowComputable.getFullId()), logger);
                            continue;
                        }
                    }
                    Object descriptor = flowComputable.getFullId();
                    if (!sourceP.isNP()) {
                        descriptor = (String)descriptor + " (partition " + sourceP.id() + ")";
                    }
                    if (sourcePartitionHash.status == DatasetReadiness.ReadinessStatus.ERROR) {
                        throw new SourceDatasetNotReadyException("Error while connecting to dataset " + (String)descriptor, sourcePartitionHash.error);
                    }
                    assert (sourcePartitionHash.status == DatasetReadiness.ReadinessStatus.NOT_READY);
                    throw new SourceDatasetNotReadyException("Input dataset " + (String)descriptor + " is not ready", sourcePartitionHash.error);
                }
            }
        }
    }

    private void computeTimestampsToPropagateBeforeActivity(Map<String, DatasetReadiness> sourcePartitionHashMap) {
        for (FlowComputable flowComputable : this.activity.getSubgraph().getSources()) {
            for (Partition sourceP : this.activity.getSubgraph().getSourcePartitions(flowComputable)) {
                DatasetReadiness sourcePartitionHash = sourcePartitionHashMap.get(this.createCacheKey(flowComputable, sourceP));
                if (!sourcePartitionHash.isReady()) continue;
                for (FlowComputable flowComputable2 : this.activity.getSubgraph().getTargets()) {
                    Partition targetP = this.activity.getSubgraph().getTargetPartition(flowComputable2);
                    HashesModel.SrcDatasetHashInfo dt = new HashesModel.SrcDatasetHashInfo(flowComputable2.getFullId(), targetP.id(), flowComputable.getFullId(), sourceP.id(), sourcePartitionHash.hash, System.currentTimeMillis(), "build: " + this.activity.id());
                    this.activity.getSubgraph().hashToPropagate.add(dt);
                }
            }
        }
    }

    private String createCacheKey(FlowComputable flowComputable, Partition partition) {
        return String.format("flowComputable__%s__%s", flowComputable.getFullId(), partition.id());
    }

    private void computeTimestampsToPropagateAfterActivity() throws Exception {
        block7: {
            RecipeHashComputer ttComputer;
            block6: {
                Partition targetP;
                if (this.activity.getSubgraph() == null) {
                    return;
                }
                ComputableHashComputer dtComputer = new ComputableHashComputer(TransactionContext.retrieveWrite().getUser());
                ttComputer = new RecipeHashComputer(this.recipesDAO, this.datasetsDAO);
                for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                    Partition partition = this.activity.getSubgraph().getTargetPartition(flowComputable);
                    HashesModel.DatasetSettingsHashInfo datasetSettingsHashInfo = new HashesModel.DatasetSettingsHashInfo(flowComputable.getFullId(), partition.id(), dtComputer.getSettingsHash(flowComputable), System.currentTimeMillis(), "build: " + this.activity.id());
                    this.activity.getSubgraph().hashToPropagate.add(datasetSettingsHashInfo);
                }
                if (!(this.activity.getSubgraph() instanceof RecipeRunnableSubgraph)) break block6;
                RecipeRunnableSubgraph recipeRunnableSubgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
                String string = ttComputer.getRecipeHash(recipeRunnableSubgraph.getRecipe());
                for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                    targetP = this.activity.getSubgraph().getTargetPartitions().get(flowComputable.getFullId());
                    HashesModel.RecipeCodeHashInfo tts = new HashesModel.RecipeCodeHashInfo(flowComputable.getFullId(), targetP.id(), this.activity.getSubgraph().getName(), string, System.currentTimeMillis(), "build: " + this.activity.id());
                    this.activity.getSubgraph().hashToPropagate.add(tts);
                }
                if (!recipeRunnableSubgraph.getRecipe().isGenerator()) break block7;
                for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                    targetP = this.activity.getSubgraph().getTargetPartitions().get(flowComputable.getFullId());
                    HashesModel.GeneratorHashInfo gts = new HashesModel.GeneratorHashInfo(flowComputable.getFullId(), targetP.id(), this.activity.getSubgraph().getName(), string, System.currentTimeMillis(), "build: " + this.activity.id());
                    this.activity.getSubgraph().hashToPropagate.add(gts);
                }
                break block7;
            }
            if (this.activity.getSubgraph() instanceof AbstractPipelineRunnableSubgraph) {
                String pipelineHash = ttComputer.getPipelineHash((AbstractPipelineRunnableSubgraph)this.activity.getSubgraph());
                for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                    Partition partition = this.activity.getSubgraph().getTargetPartitions().get(flowComputable.getFullId());
                    HashesModel.RecipeCodeHashInfo tts = new HashesModel.RecipeCodeHashInfo(flowComputable.getFullId(), partition.id(), this.activity.getSubgraph().getName(), pipelineHash, System.currentTimeMillis(), "build: " + this.activity.id());
                    this.activity.getSubgraph().hashToPropagate.add(tts);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runActivity(TransactionRef transaction) throws Exception {
        ExecutionRunnablesBuilder.JobActivityRunSpec runSpec;
        ActivityRunner activityRunner = this;
        synchronized (activityRunner) {
            this.aborter = FutureAborter.getFutureAborter();
        }
        ActivityRunner activityRunner2 = this;
        synchronized (activityRunner2) {
            if (this.abortNotified) {
                return false;
            }
            assert (this.activity.state == ActivityState.RUNNING);
            this.activity.startTime = System.currentTimeMillis();
            ExecutionRunnablesBuilder runnablesBuilder = new ExecutionRunnablesBuilder(this.activity);
            if (runnablesBuilder.usesDefaultLifecycleHook()) {
                logger.info((Object)"Executing default pre-activity lifecycle hook");
                DefaultActivityLifecycleHook lifecycleHook = new DefaultActivityLifecycleHook(this.activity);
                lifecycleHook.onPreActivity();
            }
            this.hashPropagationBehavior = SerializedRecipe.RecipeHashPropagationBehavior.getEffectivePropagationBehavior(this.projectsDAO.getMandatoryUnsafe(this.jobDef.projectKey), this.activity);
            HashMap<String, DatasetReadiness> sourcePartitionHashMap = new HashMap<String, DatasetReadiness>();
            if (this.hashPropagationBehavior != SerializedRecipe.RecipeHashPropagationBehavior.DISABLED) {
                logger.info((Object)"Checking if sources are ready");
                this.checkSourcesReady(sourcePartitionHashMap);
                logger.debug((Object)"Computing hashes to propagate BEFORE activity");
                this.computeTimestampsToPropagateBeforeActivity(sourcePartitionHashMap);
                logger.debugV("Recorded %d hashes before activity run", new Object[]{this.activity.getSubgraph().hashToPropagate.size()});
            }
            logger.debug((Object)"Building recipe runner of type");
            ExecutionRunnablesBuilder runnablesBuilder2 = new ExecutionRunnablesBuilder(this.activity);
            runSpec = runnablesBuilder2.getRunnables();
            logger.debug((Object)("Recipe runner built, will use " + runSpec.runnables.size() + " thread(s)"));
            for (FlowRunnable fr : runSpec.runnables) {
                logger.debug((Object)("Preparing execution thread: " + String.valueOf(fr)));
                FlowRunnableThread frt = new FlowRunnableThread(transaction, fr, this.activity);
                this.addRunnableThreads(frt);
            }
            ActivityRunnableThreadsHolder.setCurrentActivityRunnableThreadsHolder(this);
            this.activity.setStatusMessage(SerializedJobActivityStatus.DetailedActivityState.ACTIVE, null, null);
            for (FlowRunnableThread frt : this.getRunnableThreads()) {
                logger.debug((Object)("Starting execution thread: " + String.valueOf(frt)));
                frt.start();
            }
        }
        return this.waitForEnd(runSpec.observer);
    }

    public static class FlowRunnableThread
    extends Thread {
        private final FlowRunnable runnable;
        volatile Throwable storedException;
        private final TransactionRef transaction;
        private final JobActivity activity;

        public FlowRunnableThread(TransactionRef transaction, FlowRunnable runnable, JobActivity activity) {
            this.runnable = runnable;
            this.transaction = transaction;
            this.activity = activity;
        }

        public void setComputeResourceUsageContext(ComputeResourceUsageContext ctx) {
            CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ctx);
        }

        public Throwable getStoredException() {
            return this.storedException;
        }

        public void setStoredException(Throwable t) {
            this.storedException = t;
        }

        public FlowRunnable getFlowRunnable() {
            return this.runnable;
        }

        @Override
        public void run() {
            TransactionContext.attach((TransactionRef)this.transaction);
            Thread.currentThread().setName("FRT-" + Thread.currentThread().getId() + "-" + FlowRunnable.class.getSimpleName());
            ErrorContext.pushWithNDC((String)("act." + this.activity.id()));
            JobContext.setCurrentActivityInThread(this.activity);
            JobActivity.ActivityRunSummary currentActivitySummary = JobContext.getCurrentActivitySummary();
            if (this.activity.getSubgraph() instanceof RecipeRunnableSubgraph) {
                if (this.runnable instanceof AbstractSQLQueryLikeRecipeRunner) {
                    this.activity.runSummary.engineType = "SQL";
                } else if (this.runnable instanceof AbstractSparkBasedRecipeRunner) {
                    this.activity.runSummary.engineType = "SPARK";
                }
            } else if (this.activity.getSubgraph() instanceof SparkPipelineRunnableSubgraph) {
                currentActivitySummary.engineType = "SPARK";
            } else if (this.activity.getSubgraph() instanceof SqlPipelineRunnableSubgraph) {
                currentActivitySummary.engineType = "SQL";
            }
            logger.info((Object)("Run thread for activity " + this.activity.id() + " starting"));
            try {
                this.runnable.run();
                logger.info((Object)("Run thread done for activity " + this.activity.id()));
            }
            catch (Throwable e) {
                logger.info((Object)("Run thread failed for activity " + this.activity.id()), e);
                this.storedException = e;
            }
            finally {
                ErrorContext.popWithNDC();
                NDC.remove();
            }
        }
    }
}

