/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RecipePipelineHelperFactory {
    private final RecipePipelineHelper.PipelineType pipelineType;
    @Autowired
    private RecipesDAO recipesDAO;

    public RecipePipelineHelperFactory(RecipePipelineHelper.PipelineType pipelineType) {
        SpringUtils.getInstance().autowire((Object)this);
        this.pipelineType = pipelineType;
    }

    RecipePipelineHelper build(JobActivity jobActivity, AuthCtx authCtx) throws RecipePipelineHelperException {
        if (!(jobActivity.getSubgraph() instanceof RecipeRunnableSubgraph)) {
            throw new RecipePipelineHelperException(String.format("unexpected subgraph type: %s", jobActivity.getSubgraph().getClass()));
        }
        return this.build(((RecipeRunnableSubgraph)jobActivity.getSubgraph()).getRecipe().getModel(), jobActivity, authCtx);
    }

    public RecipePipelineHelper build(SerializedRecipe recipe, AuthCtx authCtx) throws RecipePipelineHelperException {
        return this.build(recipe, null, authCtx);
    }

    private RecipePipelineHelper build(SerializedRecipe recipe, JobActivity jobActivity, AuthCtx authCtx) throws RecipePipelineHelperException {
        try {
            String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
            return RecipeRegistry.getMeta(recipe).buildPipelineHelper(recipe, payload, this.pipelineType, authCtx, jobActivity);
        }
        catch (Exception e) {
            throw new RecipePipelineHelperException(recipe, (Throwable)e);
        }
    }
}

