/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractNewDataQualityRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMultiColumnRule
extends AbstractNewDataQualityRule
implements MetricsBasedDataQualityRule {
    public abstract List<String> getColumns();

    protected abstract List<Metric> getMetricsForOneColumn(String var1);

    protected abstract AbstractCheckContext.CheckResult runForOneColumn(String var1, AuthCtx var2, AbstractCheckContext var3, MetricsComputationService.MetricsCheckRunReport var4) throws Exception;

    @Override
    public List<Metric> getMetrics() {
        return this.getColumns().stream().flatMap(c2 -> this.getMetricsForOneColumn((String)c2).stream()).collect(Collectors.toList());
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        try {
            AbstractCheckContext.CheckOutcome outcome = AbstractCheckContext.CheckOutcome.EMPTY;
            HashMap<String, AbstractCheckContext.CheckResult> results = new HashMap<String, AbstractCheckContext.CheckResult>();
            for (String column : this.getColumns()) {
                AbstractCheckContext.CheckResult checkResult = this.runForOneColumn(column, authCtx, context, runReport);
                results.put(column, checkResult);
                outcome = AbstractCheckContext.CheckOutcome.worstOf(outcome, checkResult.outcome);
            }
            if (this.getColumns().size() == 1) {
                return (AbstractCheckContext.CheckResult)results.get(this.getColumns().get(0));
            }
            return new AbstractCheckContext.CheckResult(outcome, new Gson().toJsonTree(results).toString());
        }
        catch (ReadMetricValueHelper.ReadMetricError e) {
            return new AbstractCheckContext.CheckResult(e.outcome, e.message);
        }
        catch (MultiRunStopException e) {
            return e.result;
        }
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfig(Dataset dataset) {
        if (this.getColumns().isEmpty()) {
            return new RuleValidationError("Selected column list cannot be empty");
        }
        if (this.getColumns().stream().anyMatch(StringUtils::isBlank)) {
            return new RuleValidationError("Selected column list contains empty values");
        }
        Set schemaColumnsSet = dataset.getSchema().getColumns().stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        List listNonExistingColumns = this.getColumns().stream().filter(c2 -> !schemaColumnsSet.contains(c2)).collect(Collectors.toList());
        if (!listNonExistingColumns.isEmpty()) {
            return new RuleValidationError("Selected column(s) ['" + String.join((CharSequence)",", listNonExistingColumns) + "'] do not exist");
        }
        return this.verifyConfigOtherThanColumnsExistence(dataset);
    }

    @Nullable
    public RuleValidationError verifyConfigOtherThanColumnsExistence(Dataset dataset) {
        return null;
    }

    protected static class MultiRunStopException
    extends Exception {
        public final transient AbstractCheckContext.CheckResult result;

        MultiRunStopException(AbstractCheckContext.CheckResult result) {
            this.result = result;
        }
    }
}

