/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.GoogleUserAgentBuilder;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.GCSclient;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class GoogleCloudStorageFSProvider
implements BlobLikeFSProvider,
PathToURIConverter {
    private final GCSConnection connection;
    private final String root;
    private final String bucketName;
    private final ProxySettings proxySettings;
    private final AuthCtx authCtx;
    private GCSclient.GCSBucket gcsBucket;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.google");

    public GoogleCloudStorageFSProvider(AuthCtx authCtx, DSSConnection connection, String root, String bucketName, ProxySettings proxySettings) throws CodedIOException, DKUSecurityException {
        this.authCtx = authCtx;
        this.bucketName = bucketName;
        this.proxySettings = proxySettings;
        assert (connection instanceof GCSConnection);
        this.connection = (GCSConnection)connection;
        if (StringUtils.isBlank((String)bucketName)) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_CONFIG, "Bucket to read is not defined");
        }
        if ((root = StringUtils.trimToEmpty((String)root)).equals("..") || root.contains("../") || root.contains("/..")) {
            logger.error((Object)("Forbidden '..' segment in GCS filesystem path, root='" + root + "'"));
            throw new DKUSecurityException("Forbidden '..' segment in GCS filesystem path").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        this.root = PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.connection.params.chroot, root, false)));
        logger.info((Object)("Created GCS FS provider bucket=" + bucketName + " effectivePath=" + this.root + " from '" + this.connection.params.chroot + "' and '" + root + "'"));
    }

    private IOException tryCode(String message, Exception e) {
        if (e instanceof CodedIOException) {
            return (CodedIOException)e;
        }
        if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"Could not find or access bucket ")) {
            return new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_BUCKET_DOES_NOT_EXIST, message, (Throwable)e);
        }
        return new IOException(message, e);
    }

    private String getPathInsideRoot(String path) {
        return PathUtils.concatLNT((String[])new String[]{this.root, path});
    }

    private void checkPathInsideRoot(String path) throws DKUSecurityException {
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access '" + path + "' outside the dataset root directory").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
    }

    public void close() {
    }

    private synchronized GCSclient.GCSBucket getBucket() throws IOException {
        if (this.gcsBucket == null) {
            try {
                GCSclient client = this.connection.getClient(this.authCtx, GoogleUserAgentBuilder.buildWithSpringContext());
                this.gcsBucket = client.getBucket(this.bucketName);
            }
            catch (Exception e) {
                throw this.tryCode("Failed to connect to GCS", e);
            }
        }
        return this.gcsBucket;
    }

    @Override
    public String getRootWithinBucket() {
        return this.root;
    }

    public String convertPathToURI(String path) {
        return "gs://" + this.bucketName + PathUtils.slashes((String)(this.root + "/" + path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("bucket", this.bucketName);
        ret.put("root", this.root);
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
            ret.put("projectId", this.connection.params.projectId);
            ret.put("appSecretContent", StringUtils.defaultIfBlank((String)creds.keyJsonData, (String)creds.keyPath));
            ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (Map)ret);
        }
        return ret;
    }

    @Nullable
    private GCSclient.GCSBlobFile getBlobByName(String prefix) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            String path = this.getPathInsideRoot(prefix);
            this.checkPathInsideRoot(path);
            GCSclient.GCSBucket bucket = this.getBucket();
            logger.info((Object)("get blob " + path + " from bucket " + bucket.name));
            return bucket.getObject(PathUtils.makeNotLeadingNoTrailing((String)path));
        }
        catch (Exception e) {
            logger.info((Object)("Cannot get blob for " + prefix + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return null;
        }
    }

    @Override
    public void waitUntilReadable(String path) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (true) {
            logger.info((Object)("Waiting for GoogleCloudStorage write to complete, path=" + path));
            if (this.fileExists(path)) {
                return;
            }
            if (stopwatch.elapsed(TimeUnit.SECONDS) >= 30L) {
                throw new IOException("Timeout waiting for GoogleCloudStorage write to complete, path=" + path);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for GoogleCloudStorage write to complete, path=" + path, e);
            }
        }
    }

    @Override
    public boolean fileExists(String fileName) {
        return this.getBlobByName(fileName) != null;
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        logger.info((Object)("Start GCS Browse on bucket=" + bucket.location + " prefix=" + prefix + " path=" + path + " strategy=" + strategy.name()));
        try {
            GCSclient.GCSBlobFile object;
            FSBrowsePath ret = FSBrowsePath.makeRoot((String)prefix, (boolean)false);
            Object cleanPath = PathUtils.makeNotLeadingNoTrailing((String)path);
            if (StringUtils.isBlank((String)cleanPath)) {
                object = new GCSclient.GCSBlobFile().withName("/");
            } else {
                object = bucket.getObjectOrSubDirectory((String)cleanPath, strategy);
                if (object != null && object.isDirectory()) {
                    cleanPath = (String)cleanPath + "/";
                }
            }
            if (object == null) {
                ret = new FSBrowsePath();
            } else {
                ret.exists = true;
                ret.directory = object.isDirectory();
                if (object.isDirectory()) {
                    this.browseDirectory(bucket, ret, (String)cleanPath);
                } else {
                    ret.size = object.getSize();
                    ret.lastModified = object.getLastModified();
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
    }

    private void browseDirectory(GCSclient.GCSBucket bucket, FSBrowsePath ret, String cleanPath) throws IOException {
        List<GCSclient.GCSBlobFile> blobs = bucket.list(cleanPath, false);
        for (GCSclient.GCSBlobFile blob : blobs) {
            String itemPath = PathUtils.makeLeadingNoTrailing((String)blob.getName()).substring(this.root.length());
            if (itemPath.length() <= 0) continue;
            if (ret.children.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this GCS location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            ret.children.add(FSBrowsePath.makeElement((String)itemPath, (boolean)blob.isDirectory(), (long)blob.getSize(), (long)blob.getLastModified(), (boolean)false));
        }
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings settings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, settings);
            if (paths == null) {
                return GoogleCloudStorageFSEnumerationResult.fromNonExistingPrefix();
            }
            return GoogleCloudStorageFSEnumerationResult.fromPaths(settings.filter(paths));
        }
        catch (Exception e) {
            return GoogleCloudStorageFSEnumerationResult.fromError(e);
        }
    }

    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws IOException, DKUSecurityException {
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        String cleanPath = PathUtils.makeNotLeadingNoTrailing((String)path);
        List<GCSclient.GCSBlobFile> blobs = bucket.list(cleanPath, true);
        ArrayList ret = Lists.newArrayList();
        long totalSize = 0L;
        logger.infoV("Start GCS Enumeration on prefix=%s / path=%s", new Object[]{prefix, cleanPath});
        for (GCSclient.GCSBlobFile blob : blobs) {
            if (blob.isDirectory() || !cleanPath.isEmpty() && !blob.getName().equals(cleanPath) && !blob.getName().startsWith(cleanPath + "/")) continue;
            String itemPath = this.computeItemPath(blob);
            String filename = itemPath.substring(itemPath.lastIndexOf(47) + 1);
            long length = blob.getSize();
            if (logger.isTraceEnabled()) {
                logger.traceV("enumerate from prefix=%s - found item path=%s / size=%d", new Object[]{prefix, itemPath, length});
            }
            if (FSDatasetUtils.isBadFile(filename, settings.showHiddenFiles) || FSDatasetUtils.isBadPath(itemPath) || settings.firstNonEmpty && length == 0L || !settings.selectionRules.includes(itemPath.substring(1))) continue;
            if (ret.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this GCS location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            ret.add(new FSPath(itemPath, length, blob.getLastModified()));
            if (!settings.shouldStopEnumeration((List)ret, totalSize += length)) continue;
            break;
        }
        logger.infoV("GCS enumeration done, found %d items, %d bytes", new Object[]{ret.size(), totalSize});
        if (ret.isEmpty()) {
            return null;
        }
        FSPath exactPathFile = null;
        for (FSPath p : ret) {
            if (!p.path().equals(prefix)) continue;
            exactPathFile = p;
        }
        if (exactPathFile != null) {
            return Lists.newArrayList((Object[])new FSPath[]{exactPathFile});
        }
        return ret;
    }

    private String computeItemPath(GCSclient.GCSBlobFile blob) {
        Object itemPath = PathUtils.makeLeadingNoTrailing((String)blob.getName()).substring(this.root.length());
        if (!((String)itemPath).startsWith("/")) {
            itemPath = "/" + (String)itemPath;
        }
        return itemPath;
    }

    public FSPathOrDirectory stat(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        String requestedPath = PathUtils.makeNotLeadingNoTrailing((String)path);
        try {
            GCSclient.GCSBlobFile file = bucket.getObjectOrSubDirectory(requestedPath, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
            if (file == null) {
                return null;
            }
            if (!StringUtils.isNotBlank((String)requestedPath)) {
                file = new GCSclient.GCSBlobFile().withName("/");
            }
            if (file.isDirectory()) {
                return new FSPathOrDirectory(this.computeItemPath(file), 0L, 0L, true);
            }
            return new FSPathOrDirectory(this.computeItemPath(file), file.getSize(), file.getLastModified(), false);
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
    }

    public boolean deleteFile(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        String requestedPath = PathUtils.stripLeadingSlash((String)path);
        try {
            List<GCSclient.GCSBlobFile> blobs = bucket.list(requestedPath, false);
            for (GCSclient.GCSBlobFile blob : blobs) {
                String blobName = blob.getName();
                if (!blobName.equals(requestedPath) || blob.isDirectory()) continue;
                blob.delete();
                return true;
            }
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
        return false;
    }

    public boolean deleteDirectory(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        String requestedPath = PathUtils.stripLeadingSlash((String)path);
        try {
            List<GCSclient.GCSBlobFile> blobs = bucket.list(requestedPath, true);
            for (GCSclient.GCSBlobFile blob : blobs) {
                if (!blob.getName().startsWith(requestedPath + "/")) continue;
                blob.delete();
            }
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
        return true;
    }

    public void deleteRecursive(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        String requestedPath = PathUtils.makeNotLeadingNoTrailing((String)path);
        try {
            List<GCSclient.GCSBlobFile> blobs = bucket.list(requestedPath, true);
            for (GCSclient.GCSBlobFile blob2 : blobs) {
                if (!blob2.getName().equals(requestedPath) && !blob2.getName().startsWith(requestedPath + "/")) continue;
                blob2.delete();
            }
            List<GCSclient.GCSBlobFile> blobsAfterDeletion = bucket.list(requestedPath, true).stream().filter(blob -> blob.getName().equals(requestedPath) || blob.getName().startsWith(requestedPath + "/")).toList();
            if (!blobsAfterDeletion.isEmpty()) {
                logger.warn((Object)("Failed to delete all blobs. Still remaining: " + blobsAfterDeletion.stream().map(GCSclient.GCSBlobFile::getName).collect(Collectors.joining(","))));
            }
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
    }

    public void move(String from, String to, boolean isDirectory) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        GCSclient.GCSBucket bucket = this.getBucket();
        String fromPath = this.getPathInsideRoot(from);
        this.checkPathInsideRoot(fromPath);
        String toPath = this.getPathInsideRoot(to);
        this.checkPathInsideRoot(toPath);
        FSDatasetUtils.checkDestPathDoesNotExist(to, this.stat(to), isDirectory);
        String cleanFromPath = PathUtils.makeNotLeadingNoTrailing((String)fromPath);
        try {
            GCSclient.GCSBlobFile object = bucket.getObjectOrSubDirectory(cleanFromPath, isDirectory ? FSProvider.FSBrowseStrategy.DIRECTORY : FSProvider.FSBrowseStrategy.FILE);
            if (object == null) {
                logger.warn((Object)("No object to rename at " + from));
            } else {
                String cleanToPath = PathUtils.makeNotLeadingNoTrailing((String)toPath);
                if (object.isDirectory()) {
                    for (GCSclient.GCSBlobFile blob : bucket.list(cleanFromPath + "/", true)) {
                        if (blob.isDirectory()) continue;
                        bucket.getClient().copyItem(bucket.getName(), blob.getName(), blob.getName().replace(cleanFromPath, cleanToPath));
                        blob.delete();
                    }
                } else {
                    bucket.getClient().copyItem(bucket.getName(), object.getName(), cleanToPath);
                    object.delete();
                }
            }
        }
        catch (Exception e) {
            throw this.tryCode("Failed to connect to GCS", e);
        }
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        this.move(from, to, true);
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        this.move(from, to, false);
    }

    @VisibleForTesting
    void copyOne(String from, String to) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        GCSclient.GCSBucket bucket = this.getBucket();
        String fromPath = this.getPathInsideRoot(from);
        this.checkPathInsideRoot(fromPath);
        String toPath = this.getPathInsideRoot(to);
        this.checkPathInsideRoot(toPath);
        String cleanFromPath = PathUtils.makeNotLeadingNoTrailing((String)fromPath);
        GCSclient.GCSBlobFile object = bucket.getObject(cleanFromPath);
        if (object == null) {
            logger.warn((Object)("No object to copy at " + from));
        } else {
            String cleanToPath = PathUtils.makeNotLeadingNoTrailing((String)toPath);
            if (object.isDirectory()) {
                for (GCSclient.GCSBlobFile blob : bucket.list(cleanFromPath, true)) {
                    if (blob.isDirectory()) continue;
                    bucket.getClient().copyItem(bucket.getName(), blob.getName(), blob.getName().replace(cleanFromPath, cleanToPath));
                }
            } else {
                bucket.getClient().copyItem(bucket.getName(), object.getName(), cleanToPath);
            }
        }
    }

    public EnrichedInputStream read(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        GCSclient.GCSBlobFile blob = bucket.getObject(PathUtils.makeNotLeadingNoTrailing((String)path));
        if (blob == null) {
            throw new IOException("File '" + prefix + "' does not exist");
        }
        return new GCSEnrichedInputStream(blob, prefix);
    }

    public OutputStream write(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        GCSclient.GCSBlobFile blob = bucket.newFile(PathUtils.makeNotLeadingNoTrailing((String)path));
        return blob.getOutputStream(0L);
    }

    public void setLastModified(String prefix, long lastModified) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        GCSclient.GCSBucket bucket = this.getBucket();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathInsideRoot(path);
        bucket.setLastModified(PathUtils.makeNotLeadingNoTrailing((String)path), lastModified);
    }

    static class GoogleCloudStorageFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public GoogleCloudStorageFSEnumerationResult() {
        }

        public GoogleCloudStorageFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public GoogleCloudStorageFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static GoogleCloudStorageFSEnumerationResult fromError(Throwable error) {
            return new GoogleCloudStorageFSEnumerationResult(error);
        }

        private static GoogleCloudStorageFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new GoogleCloudStorageFSEnumerationResult(paths);
        }

        private static GoogleCloudStorageFSEnumerationResult fromNonExistingPrefix() {
            return new GoogleCloudStorageFSEnumerationResult();
        }
    }

    public static class GCSEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final GCSclient.GCSBlobFile blob;

        public GCSEnrichedInputStream(GCSclient.GCSBlobFile blob, String path) {
            super(blob.getSize(), path, PathUtils.getLastPathSegment((String)blob.getName()), path, blob::getLastModified);
            this.blob = blob;
            logger.debug((Object)("starts reading " + path));
        }

        protected InputStream getBasicInputStream() throws IOException, InterruptedException {
            return this.getBasicHeadInputStream(this.size());
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, InterruptedException {
            logger.debug((Object)("- Head input stream " + size));
            return this.blob.getInputStream();
        }
    }
}

