/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetInputHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import java.util.List;
import org.bson.conversions.Bson;

public class UnpartitionedMongoDBDatasetInputHandler
extends MongoDBDatasetInputHandler {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.mongodb");

    public UnpartitionedMongoDBDatasetInputHandler(MongoDBDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public RowsInputSplit getPartitionSplit(Partition partition) throws Exception {
        return new MongoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new MongoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return new MongoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public void createManaged() throws Exception {
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            logger.info((Object)("Creating collection: " + this.datasetHandler.config.collection));
            mongoConn.db.createCollection(this.datasetHandler.config.collection);
        }
    }

    @Override
    public long computePartitionRecords(Partition p) throws Exception {
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
            Object q = this.datasetHandler.query == null ? new BasicDBObject() : this.datasetHandler.query;
            logger.info((Object)("Counting collection: " + this.datasetHandler.config.collection + " with filter " + q.toString()));
            long result = coll.countDocuments((Bson)new BasicDBObject(q.toMap()));
            logger.info((Object)("count=" + result));
            long l = result;
            return l;
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new Exception("Unpartitioned dataset has no partitions");
    }
}

