/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public interface CanShareSQLConnection {
    public void shareSQLConnection(SQLConnectionShare var1) throws DKUSecurityException;

    public static class SQLConnectionShare {
        private final SQLConnectionProvider.SQLConnectionData connData;
        private int refCount = 0;
        private boolean failed;
        private SQLConnectionProvider.SQLConnectionWrapper conn = null;
        private static Logger logger = Logger.getLogger((String)"dip.connection.share");

        public SQLConnectionShare(SQLConnectionProvider.SQLConnectionData connData) {
            this.connData = connData;
        }

        public SQLConnectionProvider.SQLConnectionData getConnectionData() {
            return this.connData;
        }

        public synchronized SQLConnectionProvider.SQLConnectionWrapper peek() {
            return this.conn;
        }

        public synchronized SQLConnectionProvider.SQLConnectionWrapper take(AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
            logger.info((Object)("Take connection refCount=" + this.refCount));
            if (this.conn == null) {
                logger.info((Object)"  > create connection");
                this.conn = SQLConnectionProvider.newConnection(this.connData, authCtx, projectKey);
            }
            ++this.refCount;
            return this.conn;
        }

        public synchronized void give(boolean failure) throws SQLException {
            logger.info((Object)("Give connection refCount=" + this.refCount));
            --this.refCount;
            this.failed |= failure;
            if (this.refCount == 0) {
                if (this.failed) {
                    logger.info((Object)"  > closing connection with failure");
                    if (!this.conn.getAutoCommit()) {
                        this.conn.rollback();
                    }
                } else {
                    logger.info((Object)"  > closing connection");
                    if (this.connData.getDialect().supportsCommitAndRollback()) {
                        this.conn.commit();
                    }
                }
                this.conn.close();
                this.conn = null;
            }
        }

        public synchronized void close() throws SQLException {
            if (this.conn != null) {
                this.refCount = 0;
                this.conn.close();
                this.conn = null;
            }
        }
    }
}

