/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.multivariate;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.FailedResult;
import com.dataiku.dip.eda.compute.computations.NotComputedResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PCA
extends Computation.MultivariateComputation {
    public static final String TYPE = "pca";
    public Computation projectionComputation;
    public int projectionDimension;
    public String inputDataPrefix;

    public PCA(List<String> columns, Computation projectionComputation, int projectionDimension, String inputDataPrefix) {
        this.columns = columns;
        this.projectionComputation = projectionComputation;
        this.projectionDimension = projectionDimension;
        this.inputDataPrefix = inputDataPrefix;
    }

    private PCA() {
    }

    public static List<String> generateProjectionColumnNames(int projectionDimension) {
        ArrayList<String> projectionColumnNames = new ArrayList<String>();
        for (int i = 0; i < projectionDimension; ++i) {
            projectionColumnNames.add(String.format("pc%s", i + 1));
        }
        return projectionColumnNames;
    }

    public static class PCAResult
    extends AvailableResult {
        public double[] eigenvalues;
        public double[][] eigenvectors;
        public ComputationResult projectionComputationResult;

        @Override
        public List<String> collectWarnings() {
            ArrayList<String> allWarnings = new ArrayList<String>(this.projectionComputationResult.collectWarnings());
            if (this.warnings != null) {
                allWarnings.addAll(this.warnings);
            }
            return allWarnings;
        }

        @Override
        public Collection<String> collectErrors() {
            return this.projectionComputationResult.collectErrors();
        }

        @Override
        public FailedResult getFirstFailedResult() {
            return this.projectionComputationResult.getFirstFailedResult();
        }

        @Override
        public NotComputedResult getFirstNotComputedResult() {
            return this.projectionComputationResult.getFirstNotComputedResult();
        }

        @Override
        public ComputationResult.ComputationCounts getComputationCountsImpl() {
            ComputationResult.ComputationCounts computationCounts = new ComputationResult.ComputationCounts(1, 0, 0);
            return computationCounts.add(this.projectionComputationResult.getComputationCounts());
        }

        @Override
        public List<ComputationResultDataStreamer.DataStreamId> getDataStreamIds() {
            return this.projectionComputationResult.getDataStreamIds();
        }

        @Override
        public int getEstimatedMemoryUsageBytes() {
            int nbDoubles = this.eigenvalues.length;
            for (double[] eigenvector : this.eigenvectors) {
                nbDoubles += eigenvector.length;
            }
            return 32 + 8 * nbDoubles + this.projectionComputationResult.getEstimatedMemoryUsageBytes();
        }
    }
}

