/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.OneWayAnova;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class OneWayANOVACard
extends AbstractNSampTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "oneway_anova";

    public OneWayANOVACard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
    }

    private OneWayANOVACard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractNSampTestCard.AbstractCompiledNSampTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new OneWayAnova(OneWayANOVACard.this.xColumn.name, grouping, OneWayANOVACard.this.confidenceLevel);
            }

            @Override
            protected OneWayANOVACardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                OneWayAnova.OneWayAnovaResult anova = result.as(OneWayAnova.OneWayAnovaResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new OneWayANOVACardResult((List<String>)allWarnings, groups, allGroups, histogramData, anova.pvalue, anova.statistic, anova.means, anova.ciLowers, anova.ciUppers, anova.dof);
            }
        };
    }

    public static class OneWayANOVACardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double pvalue;
        public double statistic;
        public double[] means;
        public double[] ciLowers;
        public double[] ciUppers;
        public int dof;

        public OneWayANOVACardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double pvalue, double statistic, double[] means, double[] ciLowers, double[] ciUppers, int dof) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalue = pvalue;
            this.statistic = statistic;
            this.means = means;
            this.ciLowers = ciLowers;
            this.ciUppers = ciUppers;
            this.dof = dof;
        }

        private OneWayANOVACardResult() {
        }
    }
}

