/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.curves.Curve;
import com.dataiku.dip.eda.compute.curves.PolynomialCurve;
import com.dataiku.dip.eda.worksheets.cards.FitCurveCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FitCurveSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 2) {
            return Collections.emptyList();
        }
        if (!sniffedVariables.stream().allMatch(SniffedVariable::isLikelyNumerical)) {
            return Collections.emptyList();
        }
        Variable firstVariable = Suggester.toContinuousVariable(sniffedVariables.get(0));
        Variable secondVariable = Suggester.toContinuousVariable(sniffedVariables.get(1));
        return Arrays.asList(this.suggestFitCurve(firstVariable, secondVariable), this.suggestFitCurve(secondVariable, firstVariable));
    }

    private SuggestCards.SuggestedCard suggestFitCurve(Variable xVariable, Variable yVariable) {
        List<Curve> curves = Arrays.asList(new Curve[]{new PolynomialCurve(1), new PolynomialCurve(2)});
        FitCurveCard card = new FitCurveCard(xVariable, yVariable, curves);
        String cardName = String.format("Fit %s = f(%s)", yVariable.name, xVariable.name);
        return new SuggestCards.SuggestedCard(cardName, card);
    }
}

